#!/bin/sh
# the next line restarts using wish \
exec tclsh7.5 "$0" "$@"
#
# $Id: geturl7.5.tcl,v 1.2 1996/04/23 07:23:20 dl Exp $
#
# Raw WWW client - With separated data/headers - Can be used to copy
# documents, check urls, ... and as a good intro to Tcl & Binary
#
# Non blocking, event driven version
#
# by Laurent Demailly - dl@hplyot.obspm.fr - http://hplyot.obspm.fr/~dl/
# 
# (This is a rewrite of the my previous version for tclX which was a
#  rewrite of my tcl-dp' version)
# Latest version shall always be available from 
# http://hplyot.obspm.fr/~dl/wwwtools.tcl
#
# (please send me feed back, comments, and tell me if you made changes,...)
#
# GNU General Public License - Author: Laurent Demailly
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# $Log:$
#

# (fix the path)
load /usr/local/lib/tcl7.5/libbin.sl

# rcs kewords extraction
regexp {[.0-9]+} {$Revision: 1.1 $} version

# timeout in seconds
set timeout 120;

set skip 1;
set header {};

bin_new bufin  buffer 16384;
bin_new bufout subbuf 0     bufin;

#
# Proc handler, called when there is something to read on the socket:
#
proc handler {dest mode c} {
  global skip;
# puts stderr "called handler $mode,$c";
  if {$skip} {
    # we didn't finish with the header, yet.
    if {[catch {gets $c} res]} {
      puts stderr "-Error in reading : $res-";
      exit 3;
    } else {
      puts stderr $res;
      # empty line ? (can contain \r though)
      if {[regexp "^\r?\$" $res]} {
        flush stderr;
        set skip 0;
      }
    }
  } else {
    global bufin bufout;
    # we are in the data part, use 'copyfile' to allow binary (incl. \0) data
    if {[catch {bin_read $c bufin} n]} {
      puts stderr "read error $n";
      exit 4;
    } elseif {$n==0} {
      puts stderr "-eof-";
      exit 0;
    } else {
      puts stderr "read $n bytes";
      bin_resize bufout $n;
      bin_write $dest bufout;
    }
  }
}



#
# Proc timeout, called when too much time elapsed
#
proc timeout {} {
  global skip;
  puts stderr "-Timeout-";
  exit 4;
}

#
# usage remind
#
proc usage {msg} {
puts stderr "Error $msg";
puts stderr "Usage: [info script] url";
exit 1;
}

# parse command line arguments :
if {$argc==0} {usage "no url!"};

if {$argc>1} {usage "too many arguments!"};

set url [lindex $argv 0];
proc cequal {str1 str2} {
 expr [string compare $str1 $str2]==0;
}

# Do we need proxying ?
set proxy [info exist env(http_proxy)]
if {$proxy} {
  # save the original query
  set query $url
  # we parse the proxy url instead of the requested one
  set url $env(http_proxy);
}

# parse the url :
if {![regexp {^http://([^/:]+)(:([^/]*))?(/[^#]*)?(#.*)?$} $url all host p port what key]} {usage "invalid url"};

if {[cequal $port ""]} {set port 80}
if {[cequal $what ""]} {set what "/"}

if {$proxy} {
  # we just send what we were requested
  set what $query;
}

# connect to the host
if {[catch {set sock [socket $host $port]} msg]} {
  puts stderr "connect on $host port $port : $msg";
  exit 2;
}

fconfigure $sock -blocking 0 -translation binary;

# send the httpd query :
#puts "Sending GET $what to $host:$port"
puts -nonewline $sock "GET $what HTTP/1.0\r
User-Agent: dlbgeturl/$version (in Tcl7.5 by http://hplyot.obspm.fr/~dl/)\r
Accept: */*\r
\r\n"
flush $sock;

# in case of errors:
proc bgerror {mess} {
global errorInfo;
puts stderr "BACKGROUND ERROR : $mess";
puts stderr "ERRORINFO: $errorInfo";
exit 1;
}

# call handler when there is something to read :
fileevent $sock readable "handler stdout r $sock";
# timeout proc:
after [expr $timeout*1000] timeout;

# process events... 
vwait forever;

