#!/bin/sh
# the next line restarts using wish \
exec tclsh7.5 "$0" $@
#
# $Id: geturl7.5.tcl,v 1.2 1996/04/23 07:23:20 dl Exp $
#
# Raw WWW client - With separated data/headers - Can be used to copy
# documents, check urls, ... and as a good intro to Tcl & Binary
#
# Blocking version
#
# by Laurent Demailly - dl@hplyot.obspm.fr - http://hplyot.obspm.fr/~dl/
# 
# (This is a rewrite of the my previous version for tclX which was a
#  rewrite of my tcl-dp' version)
# Latest version shall always be available from 
# http://hplyot.obspm.fr/~dl/wwwtools.tcl
#
# (please send me feed back, comments, and tell me if you made changes,...)
#
# GNU General Public License - Author: Laurent Demailly
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# $Log:$
#

# If you didn't install libbin.sl yet
# copy libbin.sl to /usr/local/lib/tcl7.5
# and run
# echo 'pkg_mkIndex /usr/local/lib/tcl7.5 *[info sharedlibextension]'| tclsh7.5
# or 
#lappend auto_path .
# to test it in current directory
package require Bin;

# or more directly:
#load /usr/local/lib/tcl7.5/libbin.sl

# NB: if you host does not support shared libs building / load command,
#     replace "tclsh7.5" in the 3rd line by "tclbintest".


# rcs kewords extraction
regexp {[.0-9]+} {$Revision: 1.1 $} version

set skip 1;
set header {};

#
# usage remind
#
proc usage {msg} {
puts stderr "Error $msg";
puts stderr "Usage: [file tail [info script]] url\
             \[hashsize (default 1kb)\] > outputfile";
exit 1;
}

# parse command line arguments :
if {$argc==0} {usage "no url!"};

if {$argc>2} {usage "too many arguments!"};

set url [lindex $argv 0];
if {$argc>1} {
  set hashsize [lindex $argv 1];
  if {[catch {expr $hashsize+1>1} res] || !$res} {usage "invalid hash size"}
} else {
  set hashsize 1024;
}

proc cequal {str1 str2} {
 expr [string compare $str1 $str2]==0;
}

bin_new bufin  buffer $hashsize;
bin_new bufout subbuf 0     bufin;


# Do we need proxying ?
set proxy [info exist env(http_proxy)]
if {$proxy} {
  # save the original query
  set query $url
  # we parse the proxy url instead of the requested one
  set url $env(http_proxy);
}

# parse the url :
if {![regexp {^http://([^/:]+)(:([^/]*))?(/[^#]*)?(#.*)?$} $url all host p port what key]} {usage "invalid url"};

if {[cequal $port ""]} {set port 80}
if {[cequal $what ""]} {set what "/"}

if {$proxy} {
  # we just send what we were requested
  set what $query;
}

# connect to the host
puts stderr "Connecting $host:$port...";
if {[catch {set sock [socket $host $port]} msg]} {
  puts stderr "connect on $host port $port : $msg";
  exit 2;
}

fconfigure $sock -translation binary;

# send the httpd query :
puts stderr "Sending Get $what query...";
puts -nonewline $sock "GET $what HTTP/1.0\r
User-Agent: dlgeturl/$version (in Tcl7.5 by http://hplyot.obspm.fr/~dl/)\r
Accept: */*\r
\r\n"
flush $sock;

puts stderr "Waiting answer...";

set dest stdout;
set total 0;
while 1 {
  if {$skip} {
    # we didn't finish with the header, yet.
    if {[catch {gets $sock} res]} {
      puts stderr "-Error in reading : $res-";
      exit 3;
    } else {
      puts stderr $res;
      # empty line ? (can contain \r though)
      if {[regexp "^\r?\$" $res]} {
	puts stderr "Starting data transfer: one hash every $hashsize bytes";
        flush stderr;
        set skip 0;
      }
    }
  } else {
    # we are in the data part, use 'copyfile' to allow binary (incl. \0) data
    if {[catch {bin_read $sock bufin} n]} {
      puts stderr "read error $n";
      exit 4;
    } elseif {$n==0} {
      puts stderr "-> total = $total bytes";
      exit 0;
    } else {
      if $n==$hashsize {puts -nonewline stderr "#"}
      bin_resize bufout $n;
      bin_write $dest bufout;
      incr total $n;
    }
  }
}

