'\"
'\" $Id: document.tcl,v 1.5 1996/05/08 14:13:34 dl Exp $
'\"
'\" Some macros based on man page macros Copyright (c) 1993 The Regents of the
'\" University of California. All rights reserved. see COPYRIGHT file
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.TH TclBin n "10 May 1996" "Tcl binary extension"
.BS
.SH NAME
TclBin, bin_new, bin_def, bin_sizeof, bin_info, bin_move, bin_resize, bin_read, bin_write, bin_copy \- Binary object manipulation
.SH SYNOPSIS
\fBbin_new\fR \fIo:objectname\fR \fIs:typename\fR \fIi:sizeExpr\fR ?\fIo:father\fR? ?\fIi:offsetExpr\fR? ?\fI-no_unset\fR? 

\fBbin_def\fR \fIo:object\fR \fIs:field\fR \fIs:type\fR 

\fBbin_sizeof\fR \fItype|object\fR 

\fBbin_info\fR \fIo:object\fR 

\fBbin_move\fR ?\fI-absolute\fR? ?\fI-noerr\fR? \fIo:object\fR ?\fIi:offsetExpr\fR? ?\fIi:sizeExpr\fR? 

\fBbin_resize\fR \fIo:object\fR \fIi:newSizeExpr\fR 

\fBbin_read\fR ?\fI-nobuf\fR? \fIfileId\fR \fIo:object\fR 

\fBbin_write\fR ?\fI-nobuf\fR? \fIfileId\fR \fIo:object\fR 

\fBbin_copy\fR ?\fI-swapb|-rev4\fR? \fIo:objectDest\fR \fIo:objectSrc\fR ?\fIi:offsetDestExpr\fR? ?\fIi:offsetSrcExpr\fR? ?\fIi:sizeExpr\fR? 

.BE
.SH DESCRIPTION
These procedures provides access to binary objects and C structures
from Tcl.

Viewed from Tcl each C object is a Tcl array, each defined fields
is a sub object. Trace functions provide the read/write conversions
between Tcl strings and the Binary representation.

See also libtclbin.ps/.dvi for an introduction and overall description.
.TP
.B "bin_new"
Create a new object named \fIobjectname\fR of type \fItypename\fR.
The object created is \fIsizeExpr\fR bytes large.
If \fIfather\fR is given, no new memory is allocated and the object
is then just a pointer to a (sub)space of father data.

If the type is a registered type plus a star (*), like \fIint*\fR,
the object is considered like an array of the base type. And
accessing \fIobjectname\fR(\fBi\fR) where \fBi\fR is a number will access
the data at position \fBi\fR (starting at 0). Else, the typename
is only an information string, that can be used to check
the data allocated destination usage if needed.

For all objects, besides additional fields defined using bin_def(n),
the following fields are defined:
.RS
.TP
.I "_obj_"
Read only type name (all other fields
can be used either to get the object content or to modify it).
.TP
.I "_str_"
String representation of the object. Every instance of the character
ascii value zero ('\\0') is replaced by "\fI\\0\fR" and the
backslash itself (\\) is replaced by "\fI\\\\\fR".
.TP
.I "_hex_"
Hexadecimal representation of the object: a string of twice
the size of the object as an hexadecimal number.
.TP
.I "\fBi\fR\fI,hex\fR"
Peek/poke a byte as a two characters hexadecimal number
at offset \fBi\fR within the object.
.TP
.I "\fBi\fR"
Access \fBi\fR\fIth\fR element (starting at zero) of the object
when it has been defined as an array of a built in
type (\fItypename\fR is "\fIfloat*\fR" for instance).
.RE
.RS

Returns the object name.

Memory is allocated for the new object (unless "father" is given).
.RE

.RS
PARAMETERS:
.TP
.I "objectname"
(object) object name or "#auto" for automatically generated name
.TP
.I "typename"
(string) a type name (like \fIchar*\fR, \fIint*\fR, \fIdouble*\fR, \fImytype\fR,...)
.TP
.I "sizeExpr"
(integer) expression giving the size in bytes of the object
.TP
.I "father"
(optional object) father object name (container)
.TP
.I "offsetExpr"
(optional integer) expression giving the offset in bytes from father start, '
where to attach this object
.TP
.I "-no_unset"
(optional) if this argument is present, the object will not be
automatically unset when father is unset (dangerous)
.RE
.TP
.B "bin_def"
Define a field named within object.
Field \fIfield\fR is defined inside the binary object \fIobject\fR
(like C struct) and the corresponding TCL associative array field
is attached.

TclBin provides the following built in types :
.RS
.TP
.I "char"
character
.TP
.I "int"
integer (machine dependant, same as C type)
.TP
.I "short"
short integer (machine dependant, same as C type)
.TP
.I "netint"
32 bits unsigned integer number, in standard network order (high
byte first)
.TP
.I "netshort"
16 bits unsigned integer number, in standard network order.
.TP
.I "double"
double precision floating point number (machine dependant, same as C
type (in general IEEE)).
.TP
.I "float"
simple precision floating point number (same as C).
.TP
.I "str"
Null terminated, variable length (but not going outside object),
array of characters.
.RE
.RS

It returns the string "\fIobject(field)\fR".
.RE

.RS
PARAMETERS:
.TP
.I "object"
(object) base object name (array name)
.TP
.I "field"
(string) field name
.TP
.I "type"
(string) registered type name (built in)
.RE
.TP
.B "bin_sizeof"
returns the size in bytes of a type or object.

.RS
PARAMETERS:
.TP
.I "type|object"
name of object or type which size is wanted
.RE
.TP
.B "bin_info"
Dumps the Bin_Object structure of \fIobject\fR as a keyed list.
The following keys with values are returned:
.RS
.TP
.I "data"
Memory data pointer address (should not be used beside debugging)
.TP
.I "size"
Size in bytes (given more easily by bin_sizeof(n))
.TP
.I "father"
Father object pointer address (or NULL)
.TP
.I "type"
Type name. Also given by the \fI_obj_\fR field (which is not available
for fields, so this is currently the only normal use of this
command, beside debugging: to get the object type).
.TP
.I "elemsize"
Size of one element (in case of arrays)
.TP
.I "deleteproc, peekpokeproc, traceproc"
Internal callbacks used in object management (see "C API" section)
.RE

.RS
PARAMETERS:
.TP
.I "object"
(object) name of object
.RE
.TP
.B "bin_move"
Move (incr by 1 object position, by default) a pointer object or a
field.
The new position, in bytes, is : \fIpos+sizeof(object)\fR by default,
\fIpos+offsetExpr*sizeof(object)\fR when \fIoffsetExpr\fR is given but
\fIsizeExpr\fR is not given,
or \fIpos+offsetExpr*sizeExpr\fR if both \fIoffsetExpr\fR and
\fIsizeExpr\fR are given. \fIpos\fR being the current position or father
start when \fI\-absolute\fR flag is used.

Returns the resulting absolute offset within father.

.RS
PARAMETERS:
.TP
.I "-absolute"
(optional) If the \fI\-absolute\fR flag is used, the offset expression
is absolute
.TP
.I "-noerr"
(optional) If the \fI\-noerr\fR flag is used, trying to move the
object outside father limits will not generate an error.
.TP
.I "object"
(object) object name
.TP
.I "offsetExpr"
(optional integer) offset expression
.TP
.I "sizeExpr"
(optional integer) size expression
.RE
.TP
.B "bin_resize"
Changes the size field of an object to \fInewSizeExpr\fR. Object must be
a pointer object.

Returns the new size.

.RS
PARAMETERS:
.TP
.I "object"
(object) object name
.TP
.I "newSizeExpr"
(integer) size expression
.RE
.TP
.B "bin_read"
Reads "\fIobject'"\fRs size bytes from \fIfileId\fR into the object.

Returns the number of bytes actually read (can be less than object's
size if channel configured non blocking and writing more would block
for instance).

.RS
PARAMETERS:
.TP
.I "-nobuf"
(optional) If present will use unbuffered (read(2)) call instead
of stdio (fread(3)) call. For Tcl versions 7.5 or above this flags does not exist as only Tcl_Read(3) can be used.
.TP
.I "fileId"
Any tcl file descriptor (Channel) open for reading.
.TP
.I "object"
(object) object name
.RE
.TP
.B "bin_write"
Writes "\fIobject'"\fRs size bytes from \fIobject\fR to \fIfileId\fR.

Returns the number of bytes actually written.

.RS
PARAMETERS:
.TP
.I "-nobuf"
(optional) If present will use unbuffered (write(2)) call instead
of stdio (fwrite(3)) call. For Tcl versions 7.5 or above Tcl_Write(3) is always used but Tcl_Flush(3) is called if this flags is present.
.TP
.I "fileId"
Any tcl file descriptor (Channel) open for writing.
.TP
.I "object"
(object) object name
.RE
.TP
.B "bin_copy"
Copy (like memmove(3) (so areas can overlap)) memory from an object
(source) to another one (destination).
Checks source and destination size and copy maximum with these
constraints, or the size specified by \fIsizeExpr\fR.
If \fIoffsetDestExpr\fR or \fIoffsetSrcExpr\fR the copy starts with the
given offset or else from objects.
Returns nothing.

.RS
PARAMETERS:
.TP
.I "-swapb|-rev4"
(optional) swap bytes if \fI\-swapb\fR is given, reverse 4
bytes order (1 2 3 4 to 4 3 2 1) if \fI\-rev4\fR
.TP
.I "objectDest"
(object) destination
.TP
.I "objectSrc"
(object) source
.TP
.I "offsetDestExpr"
(optional integer) offset within destination
.TP
.I "offsetSrcExpr"
(optional integer) offset within source
.TP
.I "sizeExpr"
(optional integer) number of bytes copied
.RE
.SH C API
From C, each object is a Bin_Object structure with the following fields:
.RS
.TP
.I "magic (int)"
Magic number used to check integrity of the objects when the library
has been compiled with VERIFYSTRUCT.
.TP
.I "data (void *)"
Pointer to the actual data of the object
.TP
.I "size (size_t)"
data size (used for read/write & control)
.TP
.I "type (char *)"
pointer to the type name string (allocated at the end of the structure)
.TP
.I "father (Bin_Object *)"
father object (if object is a sub object)
.TP
.I "elemsize (size_t)"
size of a single element (if applicable : if type is an array of built
in types)
.TP
.I "DeleteProc (tfunc_obj *)"
function to be called when deleting the object (ckfree)
.TP
.I "PeekPokeProc (Tcl_VarTraceProc *)"
tcl trace proc to be called for reading/writing one element of
that type (if applicable)
.TP
.I "TraceProc (Tcl_VarTraceProc *)"
tcl trace proc to be called for reading/writing that type
(Bin_TraceObject(3) for plain objects)
.RE
.RS

See individual man pages for Bin_NewObject(3), Bin_Def(3), ...
for specific API informations.
.RE
.SH EXAMPLES
\fBbin_new\fR example
.DS
bin_new tab double* 10*[bin_sizeof double]
bin_new el2 double 8 tab1 2*8
puts $tab(_obj_) ;
puts [expr 0x$tab(3,hex)+3] ;
set tab(3,hex) 2;
puts $tab(0);
.DE

\fBbin_def\fR example
.DS
bin_new toto double* [bin_sizeof double]*10
bin_def toto dbl double 0
set toto(dbl) 5.6
.DE

\fBbin_move\fR example
.DS
bin_move el2
bin_move -absolute el2 2 1
.DE

\fBbin_resize\fR example
.DS
bin_new buf  buffer 128
bin_new line char*  16 buffer;
...
bin_resize line 32
.DE
.SH BUGS
none known.
.SH AUTHOR
Laurent Demailly
( <dl@hplyot.obspm.fr> / <URL:http://www.lyot.obspm.fr/~dl/> )
.SH VERSION
Version 2.6 (1996/05/10)
.SH CALLS
.SH FILE
tclbin/bindata.c
