' $Id: virtual.n,v 1.7 1995/11/03 13:22:53 jfontain Exp $
.TH virtual tcl
.BS
.SH NAME
virtual \- Virtual procedures in Tcl
.SH SYNOPSIS
\fBvirtual\fR \fIproc className::procedureName {this ...} ?{...}?\fR
.SH DESCRIPTION
.PP
The \fBvirtual\fR keyword can be used on member procedures. If the procedure has no body, then it is considered to be a \fBpure virtual\fR and the derived class procedure must exists and is always invoked.
.PP
If a procedure is \fBvirtual\fR but not \fBpure\fR, and a derived class procedure with the same name exists, then it is invoked in place of the base class procedure. The derived class procedure must have the same signature, that is the same number of parameters.
.PP
It is possible to invoke a virtual procedure as a non virtual one, which is handy when the derived class procedure must use the base class procedure. In this case, calling the virtual base class procedure would result in an infinite loop (see EXAMPLES section). The non virtual base class procedure name is simply the virtual procedure name with 2 semi-columns prepended.
.PP
It is illegal to make a class constructor, a destructor or a static member procedure virtual.
.SH EXAMPLES
Here is a simple example with one level of derivation. Of course, greater numbers of levels are possible and can be drawn from this.
.sp
.RS
.nf
proc \fBbase::base\fR {this parameter} {
    \fI# base members initialization ...\fR
}
proc \fBbase::~base\fR {this} {}
\fBvirtual\fR proc \fBbase::procedure\fR {this parameter} {
    \fI# invoke derived class procedure\fR
}
proc \fBderived::derived\fR {this parameter} \fBbase\fR {} {
    \fI# derived members initialization ...\fR
}
proc \fBderived::~derived\fR {this} {
    \fI# use derived members data for some cleanup ...\fR
}
proc \fBderived::procedure\fR {this parameter} {
    \fI# derived class procedure, which must exist\fR
    \fI# use non virtual base class procedure (optional)\fR
    ::base::procedure $this $parameter
    \fI# add further functionality here ...\fR
}

\fI# create derived class object\fR
set id [\fBnew\fR derived data]
\fI# call derived virtual procedure through base class\fR
base::procedure $id data
.fi
.RE
.SH KEYWORDS
stooop, new, delete, class, object
