source parray.tcl
source stooop.tcl

### check that multiply inherited base classes constructors work with variable number of arguments

# expected output:
## a::a 1 {1 2} 3
## b::b 1 x y
## c::c 1 x y {1 2} 3
## d::d 1 x y {1 2} 3
## a(1,_derived) = d
## a(1,m) = 1 2
## b(1,_derived) = d
## b(1,n) = x y
## c(1,_derived) = d
## c(1,o) = x y
## c(1,p) = 1 2
## d(1,q) = x y
## d(1,r) = 1 2

proc a::a {this args} {
    puts "a::a $this $args"
    set a($this,m) [lindex $args 0]
}
proc b::b {this p} {
    puts "b::b $this $p"
    set b($this,n) $p
}
proc c::c {this p args} {
    puts "c::c $this $p $args"
    set c($this,o) $p
    set c($this,p) [lindex $args 0]
}
proc d::d {this p args} a {$args} b {$p} c {$p $args} {
    puts "d::d $this $p $args"
    set d($this,q) $p
    set d($this,r) [lindex $args 0]
}

new d {x y} {1 2} 3
printArrays a b c d
