source parray.tcl
source stooop.tcl

### check that class constructor with multiple base classes allows new lines within base class constructors arguments

# expected output:
## a::a 1
## b::b 1
## c::c 1
## a(1,_derived) = c
## a(1,m) = x y
## b(1,_derived) = c
## b(1,n) = z
## c(1,o) = 1 2

proc a::a {this p} {
    puts "a::a $this"
    set a($this,m) $p
}
proc a::~a {this} {
    puts "a::~a $this"
}
proc b::b {this p} {
    puts "b::b $this"
    set b($this,n) $p
}
proc b::~b {this} {
    puts "b::~b $this"
}
proc c::c {this p q r} a {
    $p
} b {
    $q
} {
    puts "c::c $this"
    set c($this,o) $r
}
proc c::~c {this} {
    puts "c::~c $this"
}

new c {x y} z {1 2}
printArrays a b c
