source stooop.tcl

# expected output:
## a::a 1
## b::b 1
## b::f 1 x y z
## a::h 1 x y z
## b::g 1 x y {1 2} 3 {4 5}
## a::g 1 x y {1 2} 3 {4 5}

proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
virtual proc a::f {this p q} {
    puts "a::h $this $p $q"
}
virtual proc a::g {this p args} {
    puts "a::g $this $p $args"
}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
proc b::f {this p q} {
    puts "b::f $this $p $q"
    ::a::f $this $p $q
}
proc b::g {this p args} {
    puts "b::g $this $p $args"
    eval ::a::g $this $p $args
}

set o [new b]
a::f $o x {y z}
a::g $o {x y} {1 2} 3 {4 5}
