#
# $Id: feedback.tcl,v 1.4 1995/03/21 03:45:17 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

document_title feedback "provide feedback for long operations" {}

document_widget feedback {
    creates a toplevel window with a title and a growing status bar
    (indicating the portion of a long job that's been done).
}
dialog feedback {
    document_param steps {
	Specifies the total number of steps in the job.
    }
    param steps 10
    document_param title {
	Specifies the title that will be displayed above the status bar.
    }
    param title {}
    document_param barwidth {
	Specifies the width of the status bar.
    }
    param barwidth 200
    document_param barheight {
	Specifies the height of the status bar.
    }
    param barheight 20
    document_param barcolor {
	Specifies the color of the status bar.
    }
    param barcolor DodgerBlue
    member step 0
    method create {} {
	$self config -bd 4 -relief ridge
	label $self.title
	pack $self.title -side top -fill x -padx 2 -pady 2
        frame $self.spacer
        frame $self.bar -relief raised -bd 2 -highlightthickness 0
	pack $self.spacer $self.bar -side top -padx 10 -anchor w
        label $self.percentage -text 0%
	pack $self.percentage -side top -fill x -padx 2 -pady 2
        wm transient $self .
    }
    method reconfig {} {
	$self.title config -text $slot(title)
	$self.spacer config -width $slot(barwidth)
	$self.bar config -height $slot(barheight) -bg $slot(barcolor)
        center_window $self
    }
    document_method reset {
	Resets the status bar.
    }
    method reset {} {
	set slot(step) -1
	$self step
    }
    document_method step {
	Indicates that a step has been finished.  The length of the
	bar and the percentage figure is updated.
    }
    method step {{inc 1}} {
	if {$slot(step) >= $slot(steps)} return
        incr slot(step) $inc
        set fraction [expr 1.0*$slot(step)/$slot(steps)]
        $self.percentage config -text [format %.0f%% [expr 100.0*$fraction]]
        $self.bar config -width [expr int($slot(barwidth)*$fraction)]
        update
    }
}

