#!/bin/sh
#\
exec @tclsh@ "$0" ${1+"$@"}
#
# $Id: subst.tcl,v 1.6 1995/06/06 21:51:12 sls Exp $
#
# Make @foo@ substitutions
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

if [file isdir @stl_library@] {
    lappend auto_path @stl_library@
} else {
    lappend auto_path .
}

document_program subst.tcl "substitue values in files" {
    #subst.tcl# substitutes strings surrounded by @'s.  Invoking it as
    #subst.tcl# `src-file' `dest-dir-or-file' `?keyword=value?' `...'
    substitutes `@keyword@' with `value' in `src-file', copying the
    result to `dest-dir-or-file'.
}
if [info exists document] return

proc regsub_quote {string} {
    regsub -all {\\([0-9])} $string {\\\\\1} string
    regsub -all "&" $string {\\&} string
    return $string
}

run {
    if {$argc < 3} {
	puts stderr "usage: $argv0 src-file dest-dir-or-file ?keyword=value? ..."
	exit 1
    }
    set src [lindex $argv 0]
    set dst [lindex $argv 1]
    if [file isdir $dst] {
	set dst $dst/$src
    }
    set text [read_file $src]
    foreach pair [lrange $argv 2 end] {
	lassign {keyword value} [split $pair =]
	regsub -all @$keyword@ $text [regsub_quote $value] text
    }
    write_file $dst $text
}
