#!/bin/sh
#\
exec @tclsh@ "$0" ${1+"$@"}
#
# $Id: mksh.tcl,v 1.10 1995/08/05 20:24:40 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Write a C source file with a Tcl_AppInit that calls extension
# init functions.
#

if [file isdir @sntl_library@] {
    lappend auto_path @sntl_library@
} else {
    lappend auto_path .
}

document_program mksh.tcl "generate a Tcl_AppInit C source file" {
    #mksh.tcl# generates a C source file that contains a #Tcl_AppInit#
    function that calls the named initialization functions.  #mksh.tcl#
    can also generate a simple #main()# function that calls #Tcl_Main#.
}
document_example EXAMPLE {
    Invoking #mksh.tcl# as the following generates a C source file
    #woa_sh.c# that calls #Tcl_Init#, #Logfile_Init#, #STL_Init#,
    and #TclGdbm_Init#.
} {
    mksh.tcl -out woa_sh.c Logfile_Init STL_Init TclGdbm_Init
}
if [info exists document] return

run {
    msg_verbose
    set fp stdout
    set fns {}
    set write_tkmain 0
    set support_old_main 0
    if {[info tclversion] >= 7.4} {
	set write_main 1
	if {[info tclversion] == 7.4 && [scan [info patchlevel] "7.4b%d" beta] == 1 && $beta < 4} {
	    set support_old_main 1
	}
    }
    set default_inits Tcl_Init
    args_parse $argv {
	args_arg -nostdin {} "write code to connect stdin to /dev/null (avoids Tk's read/eval/print loop)" {
	    args_gset no_stdin 1
	}
	args_arg -append {code} "write CODE after all initializations have been called" {
	    args_gset extra_code $code
	}
	args_arg -main {} "write a main() function that calls Tcl_Main()." {
	    args_gset write_main 1
	}
	args_arg -tkmain {} "write a main() function that calls Tk_Main()." {
	    args_gset write_main 1
	    args_gset write_tkmain 1
	}
	args_arg -includetcl {} "include [info library]/init.tcl code, instead of calling Tcl_Init." {
	    args_gset default_inits STL_Tcl_Init
	    args_gset write_tcl_init 1
	}
	args_arg -rc {file} "set application rc file to FILE.  Use \"\" to mean no application file.  Defaults to ~/.tclshrc, or to ~/.wishrc if -tkmain." {
	    args_gset tclrc_file $file
	}
	args_arg -out {file} "write C source code to FILE" {
	    if [catch {args_gset fp [open $file "w"]}] {
		puts stderr "couldn't open \"$file\""
		exit 1
	    }
	}
	args_remaining "Any remainings args are the names of Init functions." {
	    args_gset fns $argv
	}
	args_error {
	    puts stderr "$detail, usage is:"
	    args_usage
	    exit 1
	}
    }
    if ![info exists tclrc_file] {
	if $write_tkmain {
	    set tclrc_file "~/.wishrc"
	} else {
	    set tclrc_file "~/.tclshrc"
	}
    }
    puts $fp "/* generated automatically -- do not edit */"
    puts $fp "#include <tcl.h>\n"
    foreach fn $fns {
	puts $fp "extern int ${fn}(Tcl_Interp* interp);"
    }
    puts $fp ""
    if [info exists write_main] {
	puts $fp "\nint main(int argc, char** argv)"
	puts $fp "{"
	if $support_old_main {
	    set main_args "argc, argv"
	} else {
	    set main_args "argc, argv, Tcl_AppInit"
	}
	if $write_tkmain {
	    puts $fp "    Tk_Main($main_args);"
	} else {
	    puts $fp "    Tcl_Main($main_args);"
	}
	puts $fp "    return 0;"
	puts $fp "}"
    } else {
	puts $fp "extern int main();"
	puts $fp "int* tclDummyMainPtr = (int*) main;"
    }
    if [info exists write_tcl_init] {
	puts $fp "\nstatic char tcl_init_source\[\] = "
	set tfp [open [info library]/init.tcl r]
	set tcl_code [read $tfp]
	close $tfp
	while {[string length $tcl_code] > 0} {
            set chunk [string range $tcl_code 0 64]
            regsub -all "\\\\" $chunk "\\\\\\" chunk
            regsub -all "\n" $chunk "\\n" chunk
            regsub -all "\t" $chunk "\\t" chunk
            regsub -all "\"" $chunk "\\\"" chunk
            puts $fp "\"$chunk\""
            set tcl_code [string range $tcl_code 65 end]
        }
	puts $fp ";"
	puts $fp "\nstatic int STL_Tcl_Init(Tcl_Interp* interp)"
	puts $fp "{"
	puts $fp "    return Tcl_GlobalEval(interp, tcl_init_source);"
	puts $fp "}"
    }
    puts $fp "\nint Tcl_AppInit(Tcl_Interp* interp)"
    puts $fp "{"
    foreach fn [concat $default_inits $fns] {
	puts $fp "    if (${fn}(interp) != TCL_OK) return TCL_ERROR;"
    }
    if [info exists extra_code] {
	puts $fp $extra_code
    }
    if [info exists no_stdin] {
	puts $fp "    freopen(\"/dev/null\", \"r\", stdin);"
    }
    if [string length $tclrc_file] {
	puts $fp "    tcl_RcFileName = \"$tclrc_file\";"
    }
    puts $fp "    return TCL_OK;"
    puts $fp "}"
    close $fp
}
