#!/bin/sh
#\
exec @tclsh@ "$0" ${1+"$@"}
#
# $Id: mkindex.tcl,v 1.6 1995/06/06 22:00:07 sls Exp $
#
# This software is copyright (C) 1995 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# Stupid script to rebuild the auto-load index.
#

if [file isdir @stl_library@] {
    set lib @stl_library@
} else {
    set lib .
}
lappend auto_path $lib

# have to be careful here, if auto load index doesn't exist then
# the document_program proc won't be autoloaded.
if [file exists $lib/tclIndex] {
    document_program mkindex.tcl "generate a Tcl auto loader index" {
	#mkindex.tcl# creates a #tclIndex# file by calling #auto_mkindex#.
    }
    if [info exists document] return
}

if {$argc == 0} {
    set dir .
    set files *.tcl
} elseif {$argc == 1} {
    set dir [lindex $argv 0]
    set files *.tcl
} else {
    set dir [lindex $argv 0]
    set files [lrange $argv 1 end]
}

puts "### Building auto-load index for \"$dir\"..."

eval [concat auto_mkindex $dir $files]
exec /bin/chmod a+r $dir/tclIndex
