# use_textsr.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_textsr"
#
proc use_textsr {w  args} {

  # data initializations

  set this(use_textsr) $w
  set this(frame0) $w.frame0
  set this(label0) $w.frame0.label0
  set this(entry0) $w.frame0.entry0
  set this(label1) $w.frame0.label1
  set this(entry1) $w.frame0.entry1
  set this(buttons) $w.buttons
  set this(sf) $w.buttons.sf
  set this(sb) $w.buttons.sb
  set this(rf) $w.buttons.rf
  set this(rb) $w.buttons.rb
  
  # widget creations

  frame $this(use_textsr) -class Use_textsr
  frame $this(frame0) 
  label $this(label0)  \
    -anchor "w" \
    -text "Search: "
  entry $this(entry0)  \
    -relief "sunken"
  label $this(label1)  \
    -anchor "w" \
    -text "Replace: "
  entry $this(entry1)  \
    -relief "sunken"
  frame $this(buttons) 
  button $this(sf)  \
    -text "S -->"
  button $this(sb)  \
    -text "<-- S"
  button $this(rf)  \
    -text "R -->"
  button $this(rb)  \
    -text "<-- R"
  
  # widget layouting

  blt_table $this(frame0) \
    $this(label0) 0,0 \
    $this(entry0) 0,1 -fill x \
    $this(label1) 1,0 \
    $this(entry1) 1,1 -fill x
  blt_table column $this(frame0) configure 0 -resize none
  blt_table $this(buttons) \
    $this(sb) 0,0 -padx 1m -pady 2m \
    $this(sf) 0,3 -padx 1m \
    $this(rb) 0,1 -padx 1m -pady 2m \
    $this(rf) 0,2 -padx 1m
  pack $this(buttons) -side bottom
  pack $this(frame0) -fill both -expand true
  
  
  if {[llength $args] > 0} {eval $w configure $args}

  return $w
}

