
puts "Reading play.tcl..."
global env CW

#------------------------------------------------------------------------
# initialise immediately after this file has been read in.
#------------------------------------------------------------------------

proc PLAY::initialise {} {

    PLAY::makeMenus

# this is done through local.tcl, if present
    PLAY::userInitialise

# no empty tags :-)
    SGML::addEmptyTags {}
}

proc PLAY::makeMenus {} {
    global PLAY
    GUI::makeMenu .bar.play "PLAY" "" "-side left" { \
        {command Help "HTML::display $CW(TCLDIR,PLAY)/play.html"} \
        {command "Builtin UserClasses" PLAY::setBuiltinUserClasses} \
        {radiobutton "Display scene" PLAY(DISPLAY,SCENE) WHOLE} \
        {radiobutton "Scene as subnodes" PLAY(DISPLAY,SCENE) ""} \
        {command "Meaningful titles" "source $CW(TCLDIR,PLAY)/title.tcl"} \
        {command "Tags as titles" \
            "proc Node::userGetMeaningfulTitle \{\{address \"\"\}\} \{\}"} \
    }
    set PLAY(DISPLAY,SCENE) ""
}

#-------------------------------------------------------------------------
# now the formatting routines...
#-------------------------------------------------------------------------

proc GRPDESCR::formatContents {parentWin address {control ""}} {
    return ==[content]==
}

#-------------------------------------------------------------------------

proc PGROUP::formatContents {parentWin address {control ""}} {
    set htext ""
    withNode node $address child withGI GRPDESCR {
        append htext "[GRPDESCR::formatContents $parentWin $address]"
    }
    append htext "<UL>"
    foreachNode node $address child withGI PERSONA {
        append htext "<LI>[PERSONA::formatContents $parentWin $address]"
    }
    append htext "</UL><BR>"
    return $htext
}

#-------------------------------------------------------------------------

proc PERSONA::formatContents {parentWin address {control ""}} {
    return [content]
}

#-------------------------------------------------------------------------

proc PERSONAE::displayNode {parentWin address {control ""}} {
    set win address
    set htext ""
    foreachNode node $address child {
        set gi [query gi]
        set address [Node::getAddress]
        if {$gi == "TITLE"} {
            append htext "[TITLE::formatContents $parentWin $address] <BR>"
        } elseif {$gi == "PERSONA"} {
            append htext "[PERSONA::formatContents $parentWin $address] <BR>"
        } elseif {$gi == "PGROUP"} {
            append htext "[PGROUP::formatContents $parentWin $address]"
        } else {
            GUI::errorMessage "PERSONAE: UNEXPECTED GI: $gi"
        }
    }
    Hypertext::display $parentWin $win $htext $control
}

#-------------------------------------------------------------------------

proc SCENE::formatContents {parentWin address {control ""}} {
    set htext ""
    foreachNode node $address child {
        set gi [query gi]
        set address [Node::getAddress]
        if {$gi == "TITLE"} {
            append htext "[TITLE::formatContents $parentWin $address] <BR>"
        } elseif {$gi == "STAGEDIR"} {
            append htext "[STAGEDIR::formatContents $parentWin $address] <BR>"
        } elseif {$gi == "SPEECH"} {
            append htext "[SPEECH::formatContents $parentWin $address]"
        } else {
            GUI::errorMessage "SCENE: UNEXPECTED GI: $gi"
        }
    }
    return $htext
}

proc SCENE::displayNode {parentWin address {control ""}} {
    global PLAY
    set win $address
    if {$PLAY(DISPLAY,SCENE) == "WHOLE"} {
        Hypertext::display $parentWin $win \
            [SCENE::formatContents $parentWin $address] $control
    } else {
        Node::displaySubnodes $parentWin $win "" $control
    }
}
    
#-------------------------------------------------------------------------

proc SPEECH::displayNode {parentWin address {control ""}} {
    set win $address
    Hypertext::display $parentWin $win \
        [SPEECH::formatContents $parentWin $address] $control
}

proc SPEECH::formatContents {parentWin address {control ""}} {
    set htext ""
    foreachNode node $address child {
        set gi [query gi]
        if {$gi == "SPEAKER"} {
            append htext "<B>[content]:</B><BR>"
        } elseif {$gi == "STAGEDIR"} {
            append htext "[STAGEDIR::formatContents {} {}] <BR>"
        } elseif {$gi == "LINE"} {
            append htext "[content]<BR>"
        }
    }
    return $htext
}

#-------------------------------------------------------------------------

proc STAGEDIR::formatContents {parentWin address {control ""}} {
    return (([content]))
}

#-------------------------------------------------------------------------

proc TITLE::formatContents {parentWin address {control ""}} {
    return "\[[content]\]"
}

#-------------------------------------------------------------------------
# these routines can be overwritten (overloaded) by the local versions
# in local.tcl
proc PLAY::userInitialise {} {}
proc PLAY::addMenuItems {menuItems} {return $menuItems}
proc PLAY::userSetBuiltinUserClasses {} {}
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# additional user routines if supplied
#-------------------------------------------------------------------------

    if {[file exists $CW(TCLDIR,PLAY)/local.tcl]} {
        source $CW(TCLDIR,PLAY)/local.tcl
    }

#-------------------------------------------------------------------------
    PLAY::initialise
#-------------------------------------------------------------------------

puts "... end of play.tcl"
