
puts "Reading costdoc.tcl..."
global env CW

#------------------------------------------------------------------------
# initialise immediately after this file has been read in.
#------------------------------------------------------------------------

proc COSTDOC::initialise {} {

    COSTDOC::makeMenus

# this is done through local.tcl, if present
    COSTDOC::userInitialise

# no empty tags :-)
    SGML::addEmptyTags {}
}

proc COSTDOC::makeMenus {} {
    global COSTDOC
    GUI::makeMenu .bar.costdoc "COSTDOC" "" "-side left" { \
        {command Help "HTML::display $CW(TCLDIR,COSTDOC)/costdoc.html"} \
        {radiobutton "Display Section" COSTDOC(DISPLAY,SECT) WHOLE} \
        {radiobutton "Section as subnodes" COSTDOC(DISPLAY,SECT) ""} \
    }
    set COSTDOC(DISPLAY,SECT) ""
}

#-------------------------------------------------------------------------
# now the formatting routines...
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------

proc SECT::formatContents {parentWin address {control ""}} {

    set translation { \
        {  "TITLE SUBSECS"                       ""     H3   ""      } \
        {  "EDNOTE NOTE GRAPHIC"                 ""     P    ""      } \
        {  "CLASS CMD SUBCMD QC EVENT NODETYPE"  ""     B    ""      } \
        {  ENV                                   "\$"   TT   ""      } \
        {  "ARG OPTARG"                          ""     I    ""      } \
        {  OPTION                                ""     B    ""      } \
        {  KEY                                   "&lt;" ""   "&gt;"  } \
        {  "MENU MENUITEM BTN"                   "\["   ""   "\]"    } \
        {  "SAMP LIT"                            ""     SAMP ""      } \
        {  VAR                                   ""     VAR  ""      } \
        {  KW                                    ""     B    ""      } \
        {  "FUNC ELEM ATTR"                      ""     TT   ""      } \
        {  TAG                                   "&lt;" TT   "&gt;"  } \
        {  "DFN DPH EMPH"                        ""     EM   ""      } \
        {  H                                     ""     H2   ""      } \
        {  "SYNOPSIS  EXAMPLE LISTING SYNTAX"    "\n"   PRE  "\n"    } \
        {  LIST                                  ""     UL   ""      } \
        {  ENUM                                  ""     OL   ""      } \
        {  IT                                    ""     LI   ""      } \
        {  "DLIST REFERENCES"                    ""     DL   ""      } \
        {  DT                                    ""     DT   ""      } \
        {  DD                                    ""     DD   ""      } \
    }

    GUI::postStatus "Patience!  doing $address"
    set htext [Node::getEventStream $address]
    set htext [HTML::translateTags $htext $translation]
    GUI::postStatus ""
    return $htext
}

proc SECT::displayNode {parentWin address {control ""}} {
    global COSTDOC
    set win $address
    if {$COSTDOC(DISPLAY,SECT) == "WHOLE"} {
        Hypertext::display $parentWin $win \
            [SECT::formatContents $parentWin $address] $control
    } else {
        Node::displaySubnodes $parentWin $win "" $control
    }
}

#-------------------------------------------------------------------------

proc BODY::displayNode {parentWin address {control ""}} {
    set win $address
    set htext ""
    foreachNode node $address child withgi SECT {
        set address [Node::getAddress]
        append htext [SECT::formatContents $parentWin $address]
puts stdout + nonewline
    }
    Hypertext::display $parentWin $win $htext $control
}


#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# these routines can be overwritten (overloaded) by the local versions
# in local.tcl
proc COSTDOC::userInitialise {} {}
proc COSTDOC::addMenuItems {menuItems} {return $menuItems}
proc COSTDOC::userSetBuiltinUserClasses {} {}
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# additional user routines if supplied
#-------------------------------------------------------------------------

    if {[file exists $CW(TCLDIR,COSTDOC)/local.tcl]} {
        source $CW(TCLDIR,COSTDOC)/local.tcl
    }

#-------------------------------------------------------------------------
    COSTDOC::initialise
#-------------------------------------------------------------------------

puts "... end of costdoc.tcl"
