
#include "tcl.h"
#include "tk.h"

int ExpandContentsAsListCmd(ClientData clientData, Tcl_Interp *interp, 
    int argc, char *argv[]);

int Tcl_AppInit(Tcl_Interp *interp)
{
    if (Tcl_Init(interp) != TCL_OK) {
	return TCL_ERROR;
    }
    
    addCostWishCommands(interp);

    return TCL_OK;
}

int main(int argc, char *argv[])
{
    Tk_Main(argc, argv, Tcl_AppInit);
    return 0;
}
 
int addCostWishCommands(Tcl_Interp *interp) {
    
    Tcl_CreateCommand(interp, "expandContentsAsList", ExpandContentsAsListCmd, 
        (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    return 0;
}

/*
    takes a white-space separated string and expands it into a Tcl list.
    called from tcl as:
        expandContentsAsList <address> [EXPAND]
    where
        address is CoST address of node
        EXPAND (optional) signifies that <integer>* prefixed to a field is
            interpreted as a multiplier
*/
    
int ExpandContentsAsListCmd(ClientData clientData, Tcl_Interp *interp, 
    int argc, char *argv[]) {
    
    char *content, *pc, *pt, *address, *temp;
    char cmd[200];
/*    char cmd[] = "set __content $content0"; */
    int i, lc;
    int inquote, inword, code, expand, addlist, multiplier, numeric, error;
    
    if (argc < 2 || argc > 3) {
        interp->result == "";
        return TCL_ERROR;
    }
    address == argv[1];
    if (argc == 3 && strcmp(argv[i], "EXPAND") == 0) {
        expand = 1;
    } else {
        expand = 0;
    }
    sprintf(cmd, "withNode address %s {set __content [content]}", address);
    printf("%s\n", cmd);
    if (Tcl_Eval(interp, cmd) == 1) {
        strcpy(cmd, "set __content $content0");
        Tcl_Eval(interp, cmd);
    }
    printf("Code: %d\n", code);

    Tcl_ResetResult(interp);
    content = Tcl_GetVar(interp, "__content", 0);
    lc = strlen(content);
    printf("lc: %d\n", lc);
    temp = (char*) malloc (sizeof(char) * lc);
    pc = content;
    inword = 0;
    inquote = 0;
    addlist = 0;
    multiplier = 0;
    numeric = 0;
    error = 0;

    while (1) {
        if (inword) {
            if (inquote) {
                if (*pc == 0) {
                    error = 1;
                    break;
                } else if (*pc != '"') {
                    *pt++ = *pc;
                } else {
                    addlist = 1;
                    inquote = 0;
                }
            } else if (isspace(*pc) || *pc == 0) {
                addlist = 1;
            } else {
                if (numeric) {
                    if (*pc == '*') {
                        *pt = 0;
                        sscanf(temp,"%d", &multiplier);
                        pt = temp; 
                        numeric = 0;
                        if (*(pc+1) == '"') {
                            inquote = 1;
                            pc++;
                            pc++;
                        }
                    } else {
                        numeric = isdigit(*pc);
                    }
                }
                *pt++ = *pc;
            }
        } else {
            if (*pc != ' ') {
                inword = 1;
                multiplier = 1;
                pt = temp;
                if (*pc != '"') {
                    if (expand && isdigit(*pc)) {
                        numeric = 1;
                    }
                    *pt++ = *pc;
                } else {
                    inquote = 1;
                }
            }
        }
        if (addlist) {
            *pt = 0;
            for (i = 0; i < multiplier; i++) {
                Tcl_AppendElement(interp, temp);
            }
            inword = 0;
            addlist = 0;
        }
        if (*pc++ == 0) break;
    }
    free(temp);
    return TCL_OK;
}
    

