
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tcl.h"

/* prototypes */
int ExpandContentsAsListCmd(ClientData clientData, Tcl_Interp *interp,
    int argc, char *argv[]);

int Cml_Init(Tcl_Interp *interp)
{

/* Register commands: */
    Tcl_CreateCommand(interp, "expandContentsAsList", ExpandContentsAsListCmd,
        (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    return 0;
}


int ExpandContentsAsListCmd(ClientData clientData, Tcl_Interp *interp, 
    int argc, char *argv[]) {
    
/* takes a white-space separated string and expands it into a Tcl list.
    called from tcl as:
        expandContentsAsList <address> [EXPAND]
    where
        address is CoST address of node
        EXPAND (optional) signifies that <integer>* prefixed to a field is
            interpreted as a multiplier
*/
    
    char *content, *pc, *pt, *address, *temp;
    char cmd[200];
    int i, lc;
    int inquote, inword, code, expand, addlist, multiplier, numeric, error;
    
    if (argc < 2 || argc > 3) {
        interp->result == "";
        return TCL_ERROR;
    }
    address = argv[1];
    if (argc == 3 && strcmp(argv[2], "EXPAND") == 0) {
        expand = 1;
    } else {
        expand = 0;
    }

/* this command will set a temporary variable __content which we then read */

    sprintf(cmd, "withNode node %s {set __content [content]}", address);
    if (Tcl_Eval(interp, cmd) == 1) {
        fprintf(stderr, "ExpandContentsAsList: failed on %s\n", cmd);
        Tcl_ResetResult(interp);
        return 1;
    }

    Tcl_ResetResult(interp);
    content = Tcl_GetVar(interp, "__content", 0);
    lc = strlen(content);
/* just to be safe - buffer is maxiumum possible */
    temp = (char*) malloc (sizeof(char) * lc);
    pc = content;
    inword = 0;
    inquote = 0;
    addlist = 0;
    multiplier = 0;
    numeric = 0;
    error = 0;

/* parse content - result returned as a list */
    while (1) {
        if (inword) {
            if (inquote) {
                if (*pc == 0) {
                    error = 1;
                    break;
                } else if (*pc != '"') {
                    *pt++ = *pc;
                } else {
                    addlist = 1;
                    inquote = 0;
                }
            } else if (isspace(*pc) || *pc == 0) {
                addlist = 1;
            } else {
                if (numeric) {
                    if (*pc == '*') {
                        *pt = 0;
                        sscanf(temp,"%d", &multiplier);
                        pt = temp; 
                        numeric = 0;
                        pc++;
                        if (*pc == '"') {
                            inquote = 1;
                            pc++;
                        } else if (isspace(*pc)) {
                            inword = 0;
                            addlist = 1;
                            *pt = 0;
                        }
                    } else {
                        numeric = isdigit(*pc);
                    }
                }
                if (!addlist) {
                    *pt++ = *pc;
                }
            }
        } else {
            if (!isspace(*pc)) {
                inword = 1;
                multiplier = 1;
                pt = temp;
                if (*pc != '"') {
                    if (expand && isdigit(*pc)) {
                        numeric = 1;
                    }
                    *pt++ = *pc;
                } else {
                    inquote = 1;
                }
            }
        }
        if (addlist) {
            *pt = 0;
            for (i = 0; i < multiplier; i++) {
                Tcl_AppendElement(interp, temp);
            }
            inword = 0;
            addlist = 0;
        }
        if (*pc++ == 0) break;
    }
    free(temp);
    return TCL_OK;
}
    

