#!/usr/bin/csh
# This stuff is to set up environment variables for SGMLS and COST
# You'll have to hack it for your installation.  To run it, use the C shell
# and type 'source setup.csh'

echo "Setting up costwish ..."

# EDIT THIS LINE: root of the costwish distribution
setenv COSTWISH $HOME/costwish

# costwishexe needs to be in the path
setenv COSTWISHEXE `which costwishexe`

#-------------------------------------------------------------------------
# all the *.tcl stuff lives here
setenv CWDIR $COSTWISH/cw

#-------------------------------------------------------------------------
# SGML
# default DTD directory - it may have a file ($CW_CATALOGS) with a catalog list
# If not it should have a single file "catalog" which is used as the default
setenv COSTWISHDTD $COSTWISH/dtd

# YOU MAY WISH TO EDIT THIS LINE: This directory needs to be writable if 
# additional catalogs are to be added by costwish
setenv CW_CATALOGS $COSTWISHDTD/cwcatalogs

# default SGML declaration
setenv SGML_DECLARATION $COSTWISHDTD/sgml.decl

#-------------------------------------------------------------------------
# These are required runtime libraries
setenv COSTWISHLIB $COSTWISH/lib

# COST
setenv COSTLIB $COSTWISHLIB/cost

# TIX
setenv TIX_LIBRARY $COSTWISHLIB/tix

#tcl/tk
setenv TCL_LIBRARY $COSTWISHLIB/tcl7.4
setenv TK_LIBRARY $COSTWISHLIB/tk4.0

#-------------------------------------------------------------------------
# This is shorthand to run the program
alias cw "$COSTWISHEXE $CWDIR/cw.tcl"

#=================SUPPORT FOR ADDITIONAL DTDs ============================
# Each directory mentioned here should have a directory foobar (where foobar
# is the DTD name), e.g. $CMLDIR has a subdirectory cml.  This directory
# contains postproc.tcl and any other postprocessing routines.

# CML
setenv CMLDIR $HOME/cml

# MARTIF
setenv MARTIFDIR $HOME/martif
