# ToDo:
# -anchor (none)
#

tixWidgetClass tixScrolledListBox {
    -classname TixScrolledListBox
    -superclass tixScrolledWidget
    -method {
    }
    -flag {
	-anchor -browsecmd -command
    }
    -static {
	-anchor
    }
    -configspec {
	{-anchor anchor Anchor w}
	{-browsecmd browseCmd BrowseCmd {}}
	{-command command Command {}}
    }
    -default {
	{.scrollbar			auto}
	{*borderWidth			1}
	{*listbox.highlightBacground	#d9d9d9}
	{*listbox.relief		sunken}
	{*listbox.background		#c3c3c3}
	{*listbox.takeFocus		1}
	{*Scrollbar.background		#d9d9d9}
	{*Scrollbar.troughColor		#c3c3c3}
	{*Scrollbar.takeFocus		0}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
    }
}

proc tixScrolledListBox::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec

    set data(x-first) 0
    set data(x-last)  1
    set data(y-first) 0
    set data(y-last)  1
}

proc tixScrolledListBox::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    set data(w:listbox) \
	[listbox $w.listbox]
    set data(w:hsb) \
	[scrollbar $w.hsb -orient horizontal]
    set data(w:vsb) \
	[scrollbar $w.vsb -orient vertical ]

    set data(pw:client) $data(w:listbox)
}

proc tixScrolledListBox::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    $data(w:listbox) config \
	-xscrollcommand "tixScrolledListBox::XView $w"\
	-yscrollcommand "tixScrolledListBox::YView $w"

    $data(w:hsb) config -command "$data(w:listbox) xview"
    $data(w:vsb) config -command "$data(w:listbox) yview"

    bind $data(w:listbox) <Return>        "tixScrolledListBox::Invoke $w"

    if {[$data(w:listbox) cget -selectmode] == "browse"} {
	bind $data(w:listbox) <Double-1> "tixScrolledListBox::Invoke $w"
    } else {
	bind $data(w:listbox) <B1-Release> "tixScrolledListBox::Invoke $w"
    }

    bind $w <Configure> "+tixScrolledListBox::Configure $w"
    bind $w <FocusIn> "focus $data(w:listbox)"

    tixAppendBindTag $data(w:listbox) TixListbox
    tixSetMegaWidget $data(w:listbox) $w
}

bind TixListbox <1> {
    if [tixGetBoolean -nocomplain [%W cget -takefocus]] {
	focus %W
    }
    tixScrolledListBox::Browse [tixGetMegaWidget %W]
}

bind TixListbox <ButtonRelease-1> {
    tixScrolledListBox::Browse [tixGetMegaWidget %W]
}

bind TixListbox <B1-Motion> {
    tixScrolledListBox::Browse [tixGetMegaWidget %W]
}

bind TixListbox <Up> {
    tixScrolledListBox::Browse [tixGetMegaWidget %W] 
}

bind TixListbox <Down> {
    tixScrolledListBox::Browse [tixGetMegaWidget %W] 
}

proc tixScrolledListBox::Browse {w} {
    upvar #0 $w data

    if {$data(-browsecmd) != {}} {
	eval $data(-browsecmd)
    }
}
#----------------------------------------------------------------------
#
#		option configs
#----------------------------------------------------------------------
proc tixScrolledListBox::config-takefocus {w value} {
    upvar #0 $w data
  
    $data(w:listbox) config -takefocus $value
}	


#----------------------------------------------------------------------
#
#		Widget commands
#----------------------------------------------------------------------


#----------------------------------------------------------------------
#
#		Private Methods
#----------------------------------------------------------------------
proc tixScrolledListBox::XView {w first last} {
    upvar #0 $w data

    set data(x-first) $first
    set data(x-last) $last

    $data(w:hsb) set $first $last
    tixWidgetDoWhenIdle tixScrolledWidget::Configure $w


}

proc tixScrolledListBox::YView {w first last} {
    upvar #0 $w data

    set data(y-first) $first
    set data(y-last) $last

    $data(w:vsb) set $first $last
    tixWidgetDoWhenIdle tixScrolledWidget::Configure $w

    # Somehow an update here must be used to advoid osscilation
    #
    update idletasks
}

#
# tixScrolledListBox::Invoke --
#
#	The user has invoked the listbox by pressing either the <Returh>
# key or double-clicking. Call the user-supplied -command function.
#
# For both -browsecmd and -command, it is the responsibility of the
# user-supplied function to determine the current selection of the listbox
# 
proc tixScrolledListBox::Invoke {w} {
    upvar #0 $w data

    if {$data(-command) != ""} {
	eval $data(-command)
    }
}

#----------------------------------------------------------------------
# virtual functions to query the client window's scroll requirement
#----------------------------------------------------------------------
proc tixScrolledListBox::GeometryInfo {w mW mH} {
    upvar #0 $w data

    return [list \
	[list $data(x-first) $data(x-last)]\
	[list $data(y-first) $data(y-last)]]
}

proc tixScrolledListBox::Configure {w} {
    upvar #0 $w data

    tixWidgetDoWhenIdle tixScrolledListBox::TrickScrollbar $w

    if {$data(-anchor) == "e"} {
	$data(w:listbox) xview 100000
    }
}

# This procedure is necessary because listbox does not call x,y scroll command
# when its size is changed
#
proc tixScrolledListBox::TrickScrollbar {w} {
    upvar #0 $w data

    if [$data(w:listbox) select include 0] {
	set inc 1
    } else {
	set inc 0
    }

    $data(w:listbox) select set 0
    if {!$inc} {
	$data(w:listbox) select clear 0
    }
}
