tixWidgetClass tixMatSphere {
    -classname TixMatSphere
    -superclass tixPrimitive
    -method {
	get render pick
    }
    -flag {
	-background -bg -foreground -fg
	-command
	-ambient -diffuse -emission -specular
	-alpha -shininess
    }
    -configspec {
	{-background background Background #ffe4c4}
	{-foreground foreground Foreground black}
	{-command command Command {}}

	{-ambient ambient Ambient {1 1 1}}
	{-diffuse diffuse Diffuse {1 1 1}}
	{-emission emission Emission {0 0 0}}
	{-specular specular Specular {0 0 0}}
	{-alpha alpha Alpha 0}
	{-shininess shininess Shininess 10.0}
    }
    -alias {
	{-bg -background}
	{-fg -foreground}
    }
}


proc tixMatSphere::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec

    set data(inited)     0
}

proc tixMatSphere::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget
 
    set data(glxwin) [glxwin $w.glx -width 120 -height 120 -rgb true -db true]

    pack $data(glxwin) -expand yes -fill both
}

proc tixMatSphere::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    bind $data(glxwin) <Expose>      "$w render"
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------
proc tixMatSphere::config-ambient {w arg} {
    upvar #0 $w data

    if {$data(idleRender) == 0} {
	set data(idleRender) 1
	tixMatSphere::RenderWhenIdle $w
    }
}

proc tixMatSphere::config-diffuse {w arg} {
    upvar #0 $w data

    if {$data(idleRender) == 0} {
	set data(idleRender) 1
	tixMatSphere::RenderWhenIdle $w
    }
}

proc tixMatSphere::config-emission {w arg} {
    upvar #0 $w data

    if {$data(idleRender) == 0} {
	set data(idleRender) 1
	tixMatSphere::RenderWhenIdle $w
    }
}

proc tixMatSphere::config-specular {w arg} {
    upvar #0 $w data

    if {$data(idleRender) == 0} {
	set data(idleRender) 1
	tixMatSphere::RenderWhenIdle $w
    }
}

proc tixMatSphere::config-alpha {w arg} {
    upvar #0 $w data

    if {$data(idleRender) == 0} {
	set data(idleRender) 1
	tixMatSphere::RenderWhenIdle $w
    }
}

proc tixMatSphere::config-shininess {w arg} {
    upvar #0 $w data

    if {$data(idleRender) == 0} {
	set data(idleRender) 1
	tixMatSphere::RenderWhenIdle $w
    }
}

proc tixMatSphere::RenderWhenIdle {w} {
    tixWidgetDoWhenIdle tixMatSphere::render $w
}

#----------------------------------------------------------------------
#                         User Commands
#----------------------------------------------------------------------
proc tixMatSphere::render {w} {
    upvar #0 $w data

    set data(idleRender) 0

    if [$data(glxwin) islinked] {
	$data(glxwin) winset
	if {$data(inited) != "1"} {
	    glwMatInit
	    set data(inited) 1
	}
	glwMatRender \
	    [lindex $data(-ambient) 0]\
	    [lindex $data(-ambient) 1]\
	    [lindex $data(-ambient) 2]\
	    [lindex $data(-diffuse) 0]\
	    [lindex $data(-diffuse) 1]\
	    [lindex $data(-diffuse) 2]\
	    [lindex $data(-emission) 0]\
	    [lindex $data(-emission) 1]\
	    [lindex $data(-emission) 2]\
	    [lindex $data(-specular) 0]\
	    [lindex $data(-specular) 1]\
	    [lindex $data(-specular) 2]\
	    $data(-alpha)\
	    $data(-shininess)

	tixDoWhenIdle glwFlush
    }
}	   

