#
# ToDo
#   (1)	If user has entered an invalid directory, give an error dialog
#

tixWidgetClass tixExDirSelectBox {
    -classname TixExDirSelectBox
    -superclass tixPrimitive
    -method {
	filter invoke
    }
    -flag {
	-browsecmd -command -dialog -dir -dircmd -directory 
	-disablecallback -selection -showhidden -value
    }
    -forcecall {
    }
    -configspec {
	{-browsecmd browseCmd BrowseCmd {}}
	{-command command Command {}}
	{-dialog dialog Dialog {}}
	{-dircmd dirCmd DirCmd {}}
	{-directory directory Directory {}}
	{-disablecallback disableCallback DisableCallback false}
	{-showhidden showHidden ShowHidden false}
	{-value value Value {}}
    }
    -alias {
	{-dir -directory}
	{-selection -value}
    }

    -default {
	{*dir.label 			{Directories:}}
	{*dir.editable 			true}
	{*dir.history 			true}
	{*dir*listbox.height 		5}
	{*TixComboBox.labelSide 	top}
	{*TixComboBox*Label.anchor 	w}
	{*dir.label.underline 		1}
	{*file.label.underline		1}
	{*types.label.underline 	15}
	{*TixComboBox.anchor 		e}
	{*TixHList.height 		7}
	{*filelist*listbox.height 	7}
	{*hidden.wrapLength 		3c}
	{*hidden.justify 		left}
    }
}

proc tixExDirSelectBox::InitWidgetRec {w} {
    upvar #0 $w data
    global env

    tixChainMethod $w InitWidgetRec

    if {$data(-directory) == {}} {
	global env

	if {[info exists env(PWD)]} {
	    set data(-directory) $env(PWD)
	} else {
	    set data(-directory) [pwd]
	}
    }
    set data(oldDir)    {}
    set data(flag)      0
}


#----------------------------------------------------------------------
#		Construct widget
#----------------------------------------------------------------------
proc tixExDirSelectBox::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    # listbox frame
    set lf [frame $w.lf]

    set data(w:dir)   [tixComboBox $lf.dir \
	-command "tixExDirSelectBox::Cmd-DirCombo $w"\
	-prunehistory true \
	-options { \
	    label.anchor w \
	}]
    set data(w:dirlist) [tixDirList  $lf.dirlist \
	-command "tixExDirSelectBox::Cmd-DirList $w"\
	-browsecmd "tixExDirSelectBox::Browse-DirList $w"]
    pack $data(w:dir)     -padx 8 -pady 4 -side top -fill x
    pack $data(w:dirlist) -padx 8 -pady 4 -side top -fill both -expand yes

    # Buttons to the right
    #
    set bf [frame $w.bf]
    set data(w:ok)     [button $bf.ok -text OK\
	-underline 0 -command "tixExDirSelectBox::Ok $w"]
    set data(w:cancel) [button $bf.cancel -text Cancel\
	-underline 0 -command "tixExDirSelectBox::Cancel $w"]
    set data(w:hidden) [checkbutton $bf.hidden -text "Show Hidden Files"\
	-underline 0\
       	-variable [format %s(-showhidden) $w] -onvalue true -offvalue false\
	-command "tixExDirSelectBox::SetShowHidden $w"]

    pack $data(w:ok) $data(w:cancel) $data(w:hidden)\
	-side top -fill x -padx 6 -pady 3

    pack $bf -side right -fill both -pady 10
    pack $lf -side left -expand yes -fill both

#    tixDoWhenMapped $w "tixExDirSelectBox::Map $w"
}


#----------------------------------------------------------------------
# Configuration
#----------------------------------------------------------------------
proc tixExDirSelectBox::config-showhidden {w value} {
    upvar #0 $w data

    set data(-showhidden) $value
    tixExDirSelectBox::SetShowHidden $w
}

# Update both DirList and {file list and dir combo}
#
#
proc tixExDirSelectBox::config-directory {w value} {
    upvar #0 $w data

    set data(-directory) $value
    tixWidgetDoWhenIdle tixExDirSelectBox::LoadFiles $w reload
}

proc tixExDirSelectBox::config-filetypes {w value} {
    upvar #0 $w data

    $data(w:types) subwidget listbox delete 0 end

    foreach name [array names data] {
	if [string match type,* $name] {
	    catch {unset data($name)}
	}
    }

    if {$value == {}} {
	$data(w:types) config -state disabled
    } else {
	$data(w:types) config -state normal
    
	foreach type $value {
	    $data(w:types) insert end [lindex $type 1]
	    set data(type,[lindex $type 1]) [lindex $type 0]
	}
	tixSetSilent $data(w:types) {}
    }
}

#----------------------------------------------------------------------
# MISC Methods
#----------------------------------------------------------------------
proc tixExDirSelectBox::SetShowHidden {w} {
    upvar #0 $w data

    $data(w:dirlist) config -showhidden $data(-showhidden)

    tixWidgetDoWhenIdle tixExDirSelectBox::LoadFiles $w reload
}

# User activates the dir combobox
#
#
proc tixExDirSelectBox::Cmd-DirCombo {w dir} {
    upvar #0 $w data

    set dir [tixResolveDir $dir]
    if {[string index $dir 0] != "/"} {
	return
    }
    if {![file isdirectory $dir]} {
	return
    }

    $data(w:dirlist) config -value $dir
    set data(-directory) $dir
}

# User activates the dir list
#
#
proc tixExDirSelectBox::Cmd-DirList {w dir} {
    upvar #0 $w data

    set dir [tixExDirSelectBox::CompressSlash $w $dir]

    tixSetSilent $data(w:dir) $dir
    set data(-directory) $dir
}

# User activates the dir list
#
#
proc tixExDirSelectBox::Browse-DirList {w dir} {
    upvar #0 $w data

    tixExDirSelectBox::Cmd-DirList $w $dir
}

proc tixExDirSelectBox::Ok {w} {
    upvar #0 $w data

    set value [$data(w:file) cget -value]
    set sel   [$data(w:file) cget -selection]

    if {$sel != {}} {
	set value $sel
    }

    if [tixExDirSelectBox::IsPattern $w $value] {
	set data(-pattern) $value
	tixWidgetDoWhenIdle tixExDirSelectBox::LoadFiles $w reload
    } else {
	if {[string index $value 0] != "/"} {
	    set data(-value) [tixExDirSelectBox::CompressSlash $w \
		$data(-directory)/$value]
	} else {
	    set data(-value) $value
	}
	tixExDirSelectBox::Invoke $w
    }
}

proc tixExDirSelectBox::Cancel {w} {
    upvar #0 $w data

    if {$data(-dialog) != {}} {
	eval $data(-dialog) popdown
    }
}

proc tixExDirSelectBox::Invoke {w} {
    upvar #0 $w data

    # Save some old history
    #
    $data(w:dir)  addhistory [$data(w:dir) cget -value]
    $data(w:file) addhistory $data(-pattern)

    if {$data(-dialog) != {}} {
	eval $data(-dialog) popdown
    }
    if {$data(-command) != {} &&
	![tixGetBoolean -nocomplain $data(-disablecallback)]} {
	$data(w:file) addhistory $data(-value)
	eval $data(-command) [list $data(-value)]
    }
}

proc tixExDirSelectBox::CompressSlash {w dir} {
    upvar #0 $w data

    set len [string length $dir]

    set lastSlash 1
    set nDir /
    for {set i 1} {$i < $len} {incr i} {
	set c [string index $dir $i]
	if {$c == "/"} {
	    if {! $lastSlash} {
		append nDir /
		set lastSlash 1
	    }
	} else {
	    append nDir $c
	    set lastSlash 0
	}
    }

    set len [expr [string length $nDir] - 1]
    if {$len != 0 && [string index $nDir $len] == "/"} {
	set nDir [string range $nDir 0 [expr $len -1]]
    }

    return $nDir
}

#
# Called when thd listbox is first mapped
proc tixExDirSelectBox::Map {w} {
    if {![winfo exists $w]} {
	return
    }

    upvar #0 $w data

    tixExDirSelectBox::Cmd-DirList $w $data(-directory)
}

#----------------------------------------------------------------------
# Public commands
#
#----------------------------------------------------------------------
proc tixExDirSelectBox::invoke {w} {
    tixExDirSelectBox::Invoke $w
}

proc tixExDirSelectBox::filter {w} {
    tixExDirSelectBox::LoadFiles $w reload
}

