# ColorSpc.tcl --
#
#	Implements the GL Widget "TixColorSpace"
#

tixWidgetClass tixColorSpace {
    -classname TixColorSpace
    -superclass tixPrimitive
    -method {
	get render pick
    }
    -flag {
	-background -bg -hsv -command -state
    }
    -configspec {
	{-background background Background #ffe4c4}
	{-hsv hsv Hsv {1.0 0.0 1.0}}
	{-command command Command {}}
	{-state state State normal}
    }
    -alias {
	{-bg -background}
    }
}

proc tixColorSpace::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec

    set data(inited)     0
    set data(idleRender) 0
}

proc tixColorSpace::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    set data(glxwin) [glxwin $w.glx -width 120 -height 120 -rgb true -db true]

    pack $data(glxwin) -expand yes -fill both
}

proc tixColorSpace::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    bind $data(glxwin) <Expose>      "tixColorSpace::IdleRender $w"
    bind $data(glxwin) <ButtonPress> "tixColorSpace::Button $w %x %y"
    bind $data(glxwin) <B1-Motion>   "tixColorSpace::Button $w %x %y"
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------
proc tixColorSpace::config-hsv {w value} {
    upvar #0 $w data

    set data(-hsv) $value
    tixColorSpace::IdleRender $w
}

#----------------------------------------------------------------------
#                         User Commands
#----------------------------------------------------------------------
proc tixColorSpace::render {w} {
    upvar #0 $w data

    set data(idleRender) 0

    if [$data(glxwin) islinked] {
	$data(glxwin) winset
	if {$data(inited) != "1"} {
	    glwCspaceInit
	    set data(inited) 1
	}
	glwCspaceRender \
	    [lindex $data(-hsv) 0] \
	    [lindex $data(-hsv) 1] \
	    [lindex $data(-hsv) 2]

	tixDoWhenIdle glwFlush
    }
}	   

proc tixColorSpace::pick {w x y} {
    upvar #0 $w data

    if {$data(-state) == "normal"} {
	if [$data(glxwin) islinked] {
	    $data(glxwin) winset
	    return [glwCspacePick $x $y]
	} else {
	    return {}
	}
    }
}

#----------------------------------------------------------------------
#                         Internal commands
#----------------------------------------------------------------------
proc tixColorSpace::Button {w x y} {
    upvar #0 $w data

    set lst [$w pick $x $y]
    if {$lst != {}} {
	set H [lindex $lst 0]
	set S [lindex $lst 1]
	set V [lindex $data(-hsv) 2]
	set data(-hsv) [list $H $S $V]

	if {$data(-command) != {}} {
	    eval $data(-command) $H $S $V
	}
	$w render
    }
}

proc tixColorSpace::IdleRender {w} {
    upvar #0 $w data

    if {$data(idleRender) == 0} {
	set data(idleRender) 1
	tixWidgetDoWhenIdle tixColorSpace::render $w
    }
}
