# Note ColorBlock is a single-buffer window. No need for swapbuffers() in
# c code.

tixWidgetClass tixColorBlock {
    -classname TixColorBlock
    -superclass tixPrimitive
    -method {
	render
    }
    -flag {
	-background -bg -rgb -width -height
    }
    -configspec {
	{-background background Background #ffe4c4}
	{-rgb rgb Rgb {1.0 1.0 1.0}}
	{-width width Width 80}
	{-height height Height 50}
    }
    -alias {
	{-bg -background}
    }
}

proc tixColorBlock::InitWidgetRec {w} {
    upvar #0 $w data

    tixChainMethod $w InitWidgetRec
    set data(inited)     0
}

proc tixColorBlock::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    set data(w:glxwin) [glxwin $w.glx -width $data(-width) \
		      -height $data(-height) -rgb true -db false]

    pack $data(w:glxwin) -expand yes -fill both
}

proc tixColorBlock::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    bind $data(w:glxwin) <Expose> "$w render"
    bind $data(w:glxwin) <Map>    "$w render"
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------
proc tixColorBlock::config-rgb {w value} {
    upvar #0 $w data

    set data(-rgb) $value
    tixColorBlock::render $w
}

proc tixColorBlock::config-width {w arg} {
    upvar #0 $w data

    $data(w:glxwin) config -width $arg
}

proc tixColorBlock::config-height {w arg} {
    upvar #0 $w data

    $data(w:glxwin) config -height $arg
}

#----------------------------------------------------------------------
#                         User Commands
#----------------------------------------------------------------------
proc tixColorBlock::render {w} {
    upvar #0 $w data

    if [$data(w:glxwin) islinked] {
	$data(w:glxwin) winset
	if {$data(inited) != "1"} {
	    glwCblockInit
	    set data(inited) 1
	}

	glwCblockRender \
	    [lindex $data(-rgb) 0] \
	    [lindex $data(-rgb) 1] \
	    [lindex $data(-rgb) 2]

	tixDoWhenIdle glwFlush
    }
}	   
