#
# Simple.tcl --
#       Simple, one-pass translation module for Cost 2.
#
# $Revision: 1.3 $

global translateSpec 
set translateSpec "translate"

environment translateEnv  \
        cdataFilter identity  \
        sdataFilter identity

proc identity {text}    { return $text }
proc output {text}      { puts stdout $text nonewline }

# switch body double-{{'ed}} due to weird uplevel parsing rules...
proc translateHandler {event} {
    uplevel #0 switch $event {{
        START {
            output [subst [$translateSpec get before ""]]
            translateEnv save
            foreach param {cdataFilter sdataFilter} {
                if [$translateSpec has $param] {
                    translateEnv set $param [$translateSpec get $param]
                }
            }
            $translateSpec do startAction
            output [subst [$translateSpec get prefix ""]]
        }
        END { 
            output [subst [$translateSpec get suffix ""]]
            $translateSpec do endAction
            translateEnv restore
            output [subst [$translateSpec get after ""]]
        }
        CDATA   { output [[translateEnv get cdataFilter] [query content]] }
        RE      { output [[translateEnv get cdataFilter] "\n"] }
        SDATA   { output [[translateEnv get sdataFilter] [query content]] }
        default { }
    }}
}

proc main {} { process translateHandler }

