#
# Numerals.tcl
# 23 Jan 1995; updated 9 May 1995
# procedures for formatting numbers:
#
#	arabic n
#		format 'n' as an arabic numberal (basically a no-op)
#	lcroman n
#	ucroman n 
#		lower- and upper-case Roman numeral
#	lcalpha n
#	ucalpha n
#		lower- and upper-case alphabetic (a, b, c, ... z).
#		barfs if n > 26.
#		%%% Need other styles:
#		%%%	a, ..., z, aa, bb, cc, ... zz
#		%%%	a, ..., z, ab, ac, ad, ... az, ba (?)
#
#  NB: all routines assume the input is in fact a number.
#

proc arabic {n} { return [string trim $n] }

# romanNumeral: internal routine
proc romanNumeral {x} {
    set result ""
    if {$x < 0} {
	set x [expr - $x] 
	set result "negative "
    }
    if {$x == 0} {
	error "No roman numeral for zero"
    }
    # {40 il} %%%?
    foreach elem {
	{ 1000	m  }    { 900	cm }    
	{ 500	d  }    { 400	id }    
	{ 100	c  }    { 90 	ic }    
	{ 50 	l  }    
	{ 10 	x  }    { 9 	ix }    
	{ 5 	v  }    { 4 	iv }    
	{ 1 	i  }
    } {
	set digit [lindex $elem 0]
	set roman [lindex $elem 1]
	while {$x >= $digit} {
	    append result $roman
	    incr x -$digit
	}
    }
    return $result
}

proc ucroman {x} {
    string toupper [romanNumeral $x]
}

proc lcroman {x} {
     romanNumeral $x
}


global _numeral_alphabet;
set _numeral_alphabet {a b c d e f g h i j k l m n o p q r s t u v w x y z}

proc lcalpha {n} {
    global _numeral_alphabet
    if {$n > 26} { error "Number out of range $n > 26" }
    return [lindex  ${_numeral_alphabet} [expr $n - 1]]
}

proc ucalpha {n} {
    global _numeral_alphabet
    if {$n > 26} { error "Number out of range $n > 26" }
    return [string toupper [lindex  ${_numeral_alphabet} [expr $n - 1]]]
}

