#
# Core.tcl
# Core CoST utilities
#
# $Revision: 1.2 $
#

### Debugging and warning message handling:

proc DEBUG {key msg} {}
proc warning {text} { puts stderr "Warning: $text" }

### Convenience functions for reading SGMLS output

# load SGMLS output from file
proc loadfile {filename} {
    set fp [open $filename r]
    loadsgmls $fp
    close $fp
}

# invoke sgmls as a subprocess
proc loaddoc {filename} {
    global env;
    set cmd "|sgmls"
    if [info exists env(SGML_DECLARATION)] {
	append cmd " $env(SGML_DECLARATION)"
    }
    append cmd " $filename"
    set fp [open "$cmd" r]
    loadsgmls $fp
    close $fp
}

### List processing utilities:

# luniq: remove duplicate entries from a list
proc luniq {l} {
    set l [lsort $l]
    set lastel [lindex $l 0]
    set result [list $lastel]
    foreach el $l {
	if {$el != $lastel} {
	    lappend result $el
	    set lastel $el
	}
    }
    return $result
}

# lreverse: reverse a list
proc lreverse {l} {
    set result ""
    set i [expr [llength $l]-1 ]
    while {$i >= 0} {
	lappend result [lindex $l $i]
	incr i -1
    }
    return $result
}

# shift: remove element from head of list
proc shift {varname} {
    upvar $varname l
    set head [lindex $l 0]
    set l [lrange $l 1 end]
    return $head
}


### Extra SGML utilities:

# From DSSSL:
# "The _child number_  of an element is the number of
# element siblings of the current element that are before or 
# equial to the current element and that have the same
# generic identifier as the current element." 
# Useful for constructing section numbers, etc.
#
proc childNumber {} {
    return [expr 1 + [countq prev el withGI [query gi]]]
}

# hierarchyNumbers gi: 
# rough equivalent of DSSSL "hierarchical-number-recursive";
# returns a list of the child numbers of each ancestor
# with generic identifier 'gi'
#
proc hierarchyNumbers {gi} {
    set hn {}
    foreachNode rootpath el withGI $gi {
	lappend hn [childNumber]
    }
    return $hn
}

