#
# costinit.tcl
# Initialization file for CoST 2
# $Revision: 1.4 $
#

global COSTLIB
if {[info exists env(COSTLIB)]} {
    set COSTLIB $env(COSTLIB)
} elseif {![info exists COSTLIB]} {
    set COSTLIB /usr/local/lib/cost 
}

#
# Source file management:
#
global __searchPath
if {[info exists env(COSTPATH)]} {
    set __searchPath [split $env(COSTPATH) ":"]
}
lappend __searchPath $COSTLIB
lappend __searchPath $COSTLIB/utils

proc require {filename} {
    global __loadedFiles __searchPath
    if {[info exists __loadedFiles($filename)]} return
    if {[file exists $filename]} {
	uplevel #0 source $filename
	set __loadedFiles($filename) $filename
	return;
    } 
    foreach dir $__searchPath {
	if {[file exists $dir/$filename]} {
	    uplevel #0 source $dir/$filename
	    set __loadedFiles($filename) $dir/$filename
	    return;
	}
    }
    error "require: Can't find $filename"
}

#
# Package management:
#
proc haveExtension {ext} {
    global COST
    return [expr [lsearch $COST(EXTENSIONS) $ext] != -1]
}

proc needExtension {ext} {
    if ![haveExtension $ext] {
	puts stderr "COST Error: this script requires the $ext extension"
	exit 1
    }
}

#
# Load core utilities:
#
require utils/Core.tcl


#
# Base class for itcl event handlers
#

if {[haveExtension ITCL]} {
  itcl_class EventHandler {
    method START {} {}
    method END {} {}
    method CDATA {} {}
    method SDATA {} {}
    method RE {} {}
    method DATAENT {} {}
    method PI {} {}
  }
}

### costsh-specific commandline processing:
#
# costsh [-S specfile]
#

proc cost_commandline {} {
    global argv
    set filter 0
    while {[string match "-*" $argv]} {
	switch -- [set option [shift argv]] {
	    -S {
		set specfile [shift argv]
		set filter 1
		break;
	    }
	    -f {
		set filter 1 
	    }
	    default {
	       error "unrecognized option $arg" 
	   }
	}
    }
    if {$filter} {loadsgmls stdin}
    if {[info exists specfile]} {
	require $specfile
	if { [lsearch [info procs] main] != -1 } { main }
    }
}

### Startup:

cost_commandline

