#!/bin/csh

cat > dtd2html.tcl << !
#!/usr/local/bin/tclsh

# dtd2html does not understand sgmls '-i ' keyword so we have
# to preprocess the DTDs

proc removeDOC {infile outfile} {
    set if [open \$infile r]
    set of [open \$outfile w]
    set dtdout 1
    while {![eof \$if]} {
        gets \$if line
        set lineout 1
        if {[string first "<\!\[ \%DOC \[" \$line] != -1} {
            set dtdout 0
            set lineout 0
        } elseif {[string first "<!\[ %DTD \[" \$line] != -1} {
            set dtdout 1
            set lineout 0
        }
        if {\$dtdout && \$lineout} {
            puts \$of \$line
        }
    }
    close \$if
    close \$of
}

proc removeDTD {infile outfile HTMLDIR} {
    
    set if [open \$infile r]
    set of [open \$outfile w]
    set docout 1
    set list 0
    set gi ""
    while {![eof \$if]} {
        gets \$if line
        set lineout 1
        if {[string first "<\!\[ \%DOC \[" \$line] != -1} {
            set docout 1
            set lineout 0
        } elseif {[string first "<!\[ %DTD \[" \$line] != -1} {
            set docout 0
            set lineout 0
        }
        if {[regexp "<--.*-->" \$line]} {
            set lineout 0
        }
        if {[regexp "<D.EL *GI=(.*)>" \$line junk gi]} {
            puts \$of "<H2><A HREF=\"\$HTMLDIR/[string tolower \$gi].html\">\$gi</A></H2>"
            set list 1
            set gi [string toupper \$gi]
        }
        regsub "<D\.CONT>" \$line "<H2>Content</H2><TT>" line
        regsub "</D\.CONT>" \$line "</TT>" line
        if {[regexp "<D.ATT ATT=(\[^ >\]*)\[ \]*>" \$line junk att]} {
            if {\$list == 1} {
                puts \$of "<H2>Attributes</H2>"
                puts \$of "<UL>"
                set list 2
            }
            puts \$of "<LI><B>\$att</B><A HREF=\"\$HTMLDIR/[string tolower \$gi].attr.html\">  (Full spec)</A><BR>"
        }
        if {[regexp "</D.EL>" \$line]} {
            if {\$list == 2} {
                puts \$of "</UL>"
            }
            set list 0
        }
        
        if {\$docout && \$lineout} {
            puts \$of \$line
        }
    }
    close \$if
    close \$of
}
    foreach dtd [glob *.dtd] {
        set root [file root \$dtd]
        puts "making *.html for \$dtd"
        cd dtd2html/
        exec cp  ../\$dtd \$dtd-sav
        removeDOC \$dtd-sav \$dtd
        cd ..
        removeDTD \$dtd \$root.html htmldoc
    }
    exit
!

chmod +x dtd2html.tcl
dtd2html.tcl
rm dtd2html.tcl

echo "Running dtd2html"
cd dtd2html/
dtd2html \
    -mapfile dtd2html.map \
    -homename cmlHome.html \
    -tree \
    -outdir ../htmldoc \
    cml.dtd
cd ..

echo "Finished"

