# this runs under costwish, to make an the glossary in HTML

proc readEntry {id address} {
    global VHG
    set synonyms ""
    withNode node $address child withGI TIG {
        withNode child withGI TERM {
            set name [content]
        }
        withNode child withgi DESCRIP {
            set descrip [content]
        }
        foreachNode ysib withgi TIG child withgi TERM withattval TYPE synonym {
            lappend synonyms [content]
        }
    }
    return [list $name $descrip $synonyms]
}

proc writeEntry {id name descrip synonyms} {
    set f [open $id.html w]
    puts $f "<H2>$name</H2>"
    foreach synonym $synonyms {
        puts $f "<I>Synonym:</I> $synonym<BR>"
    }
    puts $f "<BR>"
    puts $f $descrip
    close $f
}

proc markupDescrip {descrip words idarray name} {
    upvar $idarray ID
    set lcdescrip [string tolower $descrip]
    foreach word $words {
        if {$word == $name} continue
        set f [string first $word $lcdescrip]
        if {$f != -1} {
            if {[regexp -indices "\[^a-z\]$word\[^a-z\]" $lcdescrip range]} {
                set i1 [lindex $range 0]
                set i2 [lindex $range 1]
                set last [string range $descrip $i2 end]
                set mid [string range $descrip [expr $i1+1] [expr $i2-1]]
                set descrip [string range $descrip 0 $i1]
                append descrip "<A HREF=\"$ID($word).html\">$mid</A>$last"
                set lcdescrip [string tolower $descrip]
            }
        }
    }
    return $descrip
}

# load the glossary into SGMLS - you may need to change the directories
proc loadSGM {file} {

    global env
    exec sgmls -m $env(HOME)/costwish/dtd/catalog \
        $env(HOME)/costwish/dtd/sgml.decl ./_glossary.sgm > junk.esis

    set f [open junk.esis r]
    loadsgmls $f
    close $f
    exec rm junk.esis
}

    loadSGM ./_glossary.sgm
    puts stdout "loaded SGML"

    set f [open _glossary.html w]
    puts $f "<H1>SGML glossary</H1>"
    puts $f "These are some of the terms that are used in the costwish documentation, with my own explanations.  I have deliberately avoided formal SGML language, in many places.  I apologise for any errors or imprecisions and would be grateful for corrections.  The cross-referencing (entalied terms) has been done automatically and there are a few places where it isn't quite right (mainly a capitalisation problem).  I'll correct it soon."
    puts $f "<UL>"
    foreachNode doctree withGI termentry {
        set address [query address]
        set id [string tolower [query attval ID]]
        set list [readEntry $id $address]
        lappend ids $id
        set name [lindex $list 0]
        lappend names $name
        set DESCRIP($name) [lindex $list 1]
        set SYNONYMS($name) [lindex $list 2]
        set ID([string tolower $name]) $id
        puts $f "<LI><A HREF=\"$id.html\">$name</A></LI>"
    }
    puts $f "</UL>"
    puts $f "<I>Peter Murray-Rust</I><BR>April 1996"
    close $f
    puts stdout "read files"

    set lcnames [string tolower $names]
    foreach name $names {
        set lcname [string tolower $name]
puts $lcname..
        set id $ID($lcname)
        set DESCRIP($name) [markupDescrip $DESCRIP($name) $lcnames ID $lcname]
        writeEntry $id $name $DESCRIP($name) $SYNONYMS($name)
    }

    exit
