#!/usr/local/bin/costwish

proc loadSGML {} {
    set HOME "/usr/people/pmr1716"
    exec sgmls -i pmraddition -m $HOME/costwish/dtd/catalog -m $HOME/martif/dtd/catalog -m $HOME/vhg/cat/catalog $HOME/costwish/dtd/sgml.decl _glossary.sgm > junk.esis
    loadfile junk.esis
}
    
proc countEntries {} {
    global VHG
    set VHG(NENTRIES) 0
    foreachNode doctree withgi termentry {
        incr VHG(NENTRIES)
        set id [string trim [string tolower [query attval id]]]
        set VHG(COUNT,$id) $VHG(NENTRIES)
    }
}
    
proc getLinks {} {
    global VHG
    foreachNode doctree hasatt target {
        set target [string tolower [query attval target]]
        set address [query address]
        set parent NULL
        withNode node $address ancestor withgi termentry {
            set parent [string tolower [query attval id]]
        }
        addLink $parent $target
    }
}

proc addLink {parent target} {
    global VHG
# don't use external refs
    if {[regexp {(gopher:|ftp:|http:|\.gif)} $target]} return
    if {$parent == "NULL"} return
    if {$VHG(COUNT,$parent) != $VHG(COUNT,$target) && \
        ![info exists VHG(OUTPUT,$VHG(COUNT,$parent),$VHG(COUNT,$target)]} {
        puts "$VHG(COUNT,$parent) $VHG(COUNT,$target)"
        set VHG(OUTPUT,$VHG(COUNT,$parent),$VHG(COUNT,$target) 1
    }
}


    loadSGML
    countEntries
    getLinks

    
