proc CW::currentTutorial {} {
    global CW

    CW::reset
    
    set msg \
"                            SEARCHING 
			    (Advanced)
This tutorial concentrates on how to search a (text) SGML document and to store the results.  These facilities are very new so please let us have your WIBNIs (Wouldn't It Be Nice If).  It is easy to develop them in many different ways (e.g. saving the results, restructuring the information).

We shall use Julius Caesar as the document so you should be familiar with tutorial 2. and you should also have followed the tutiral (3) on commands and scripts.

First some terms.  In an expression like:

    <A HREF=\"file.html\" REL=\"glossary\"><B>extra</B> <I>help</I></A>

A is an GI (generic identifier).
HREF is an attribute of A
'file.html' is the value of the attribute (or attval) of HREF
\{HREF REL\} is the list of attributes of A (or attlist)
'<B>extra</B> <I>help</I>'  is the content of A
'extra help' is the CDATA content of A
B and I are children of A; A is the parent of B; 
I is the younger sibling (ysib) of B
'extra' is the content of B; 'help' is the content of I

Note that in (strict) SGML the case of GIs and attributes is irrelevant, but the case of attribute values and content matters.  The quotes round the attribute values are stripped (and it's good practice to use them for all attvals).  Unfortunately many HTML browsers have been written to accept incorrect SGML so learning-by-example from HTML is a poor way.

The *context* of information is very valuable; we could ask for 'all Bs which occur in the content of As'.  In the Shakespeare markup, TITLE is used both for the title of the play and for the titles of SCENES; these can be distinguished by their context.
 
The document will be loaded...
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set CW(DISPLAY,ADDRESS) 1
    SGML::loadDocument SGML $CW(DEMODIR)/caesar.sgm

    set msg \
"The document should now be loaded.  For this exercise I have switched on the display of node addresses to make it clear which nodes I am referring to.  The node addresses remain constant for any document (by would change if it were edited).

As an example, the address of the TITLE of the play is 1:2 . Click on it to display the content ('The Tragedy of Julius Caesar').  Notice that there are about 3500 nodes in the document - all unique.  Thus ACT II is 791:2.

Joe's searching tools are very powerful, but expect you to know a bit of tcl.  I'll take you through a simple example, but in most cases you wouldn't do this interactively, but would write a script and submit it to CoST.  Let's search for all TITLEs.  We use the phrase:

    doctree withgi TITLE

Don't panic!  What this means is:

doctree - go through every node in the document
withgi - look for the GI 
TITLE - only accept those with GI==TITLE

We also have to store the results as a LIST.  tcl's lists can be complex, but it this case it should be just a list of addresses separated by single spaces.  I'll have to store the result in a tcl variable, so what I'll actually do is:

    foreachNode doctree withgi TITLE \{lappend addresses \[query address\]\}

and display the results in a message box.  The 'foreachNode' executes a command for each 'hit', the command being to lappend (list-append) to variable 
'addresses' the address of each hit ('query address').  Don't panic!  We shan't have any more of this ...
 
You shouldn't try this from the command line!  (it can be done, but you need to know about quoting and global variables).
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    foreachNode doctree withgi TITLE {lappend addresses [query address]}
    set msg \
"These are all the nodes in the document with GI==TITLE:

$addresses.

If you look at the TOC you'll see TITLE(1:2), the title of the play and you'll also see the titles of each ACT (51:3, 791:3, etc).  If you want to see the *content*, just click on the node.  But where is 6:3?  See the next page...
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    set msg \
"
If you set 'Node Action|Expand Subtree' and then click on 'PERSONAE(6:2)' you'll get all the children of PERSONAE.  One of these (6:3) is a TITLE whose content is 'Dramatis Personae'.

(You don't normally use numeric addresses.  If you do have to, any node can be displayed by the Node::display routine.  Try entering:
    Node::display 6:3 6:3 
on the command line.)

CoST can be made to do extremely complex searches for which only the command-line approach will work.  For simple searches such as the one we've just done, it's possible to create a GUI interface and that's what I'll show you now.
"

    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    set msg \
"We'll now repeat the operation using the 'Search' menu.  Click on 'Search|Search/UCs'...

This box allows you to set up a query of the type:
    find all GIs 
        (optionally) in the context of other GIs
        (optionally) with certain attributes
        (optionally) with certain attribute values
        (optionally) with certain content

So let's search for all TITLEs (as before).  Make sure that the left 'GI' button is active and that 'Context' is set to 'None'.  Set 'GI' to 'TITLE'  (note that costwish has worked out what the possible nodes are...).  Hit search and wait a few seconds."

    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"You now have a box of the results - perhaps rather boring, but a precise capture of all the TITLEs.  Rather than look at them, we'll save them.

costwish uses the idea of 'UserClasses' (UC).  (I have chosen this rather than CLASS, since HTML will some day use class and I don't wish to have collisions :-).  So we'll give these results the UserClass 'title' which is entered in the left bottom entry widget.  It's useful to add an annotation (e.g. 'all titles' in the right hand widget).  Think of UserClasses as additional names to can give to nodes - a node can belong to any number of UserClasses.

Now let's search for all TITLEs of ACTs.  We phrase this as:
    ACT with child TITLE
(CoST returns the address of the rightmost node, so phrase it this way rather than the possibly more natural:
    TITLEs with parent ACT
(which would return the ACT).  On the GUI select ACT for the left GI, 'child' for the 'Context' and TITLE for the right GI.  (All other fields must be blank and Matches set to exact).  Press 'Search'

If you've done this right, you should get five TITLEs.  Record these as (say)
acttitle UserClasses.  Note that these have been highlighted in the TOC so that you can find your way around the document."

    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Now let's try some content searching.  (There are no attributes in this document, so leave those blank.)  We'll look for all speeches by VARRO (a minor part).
'VARRO' (in capitals) will occur as the exact content of a SPEAKER node.  (You have to know how the document was marked up to run these searches!).  Check your settings very carefully:

    left-Gi               SPEAKER
    context               None
    right-GI              <ignored>
    Att Name, Att value    blank
    Content               VARRO
    Case (content)        <unset>
    Match                 exact

Press 'Search'.  VARRO should occur six times as a SPEAKER.  If you want to find out what he says in each, click on 'SPEAKER' and then click on its 'Parent'.
The first speech should be 'Calls my lord?' and the last (with CLAUDIUS) is 'It shall be done, my lord.'  Already we have a tool to help actors learn their lines :-)
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Most searches will probably *not* be for precise content, but for words or phrases which can be part of the content (possibly in unknown case).  If you know how to use (tcl) regular expressions, this can be extremely powerful, but we'll give an example of the much simpler 'glob' method.

Let's search for all TITLEs which have something to do with Rome.  For example, ACT I, SCENE I has a TITLE with the content:
    SCENE I. Rome. A street.
Since we don't know what comes before or after the 4 characters R-O-M-E we use qa wildcard which says 'any character including none':
    *rome*
This could also give false hits (such as Hippodrome) and for complete precision I would recommmend regexp's.  We've also made this case-insensitive since the author might have used ROME in places.  Set up the search:
    left-Gi               TITLE
    context               None
    right-GI              <ignored>
    Att Name, Att value    blank
    Content               *rome*
    Case (content)        <unset>
    Match                 glob

Press 'Search'.  You should get 4 TITLEs which contain the string 'rome'.
See if they really do!  

It's easy to misconstruct searches, so if you get no hits for something, check very carefully before assuming it's not there.  It's particularly easy to make mistakes if context, content and attributes are all used in a search.

"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"There's lot's more that can be done.  For example, see if you can find all places where two people speak at once.  (SPEAKER with ysib SPEAKER).  I found three.

For complex queries it may be useful to store intermediate results and combine them.  I've provided a simple interface to carry out simple Boolean operations on UserClasses (AND, NOT, OR).  Find 'Search|UserClasses' and by pressing 'Q' (alltitles) 'NOT' and 'Q' (acttitles), you should have constructed the query 'alltitles NOT acttitles'.  Give it a useful name (e.g. nonacttitles) , and 'Submit'  The result appears as another row and can be displayed.  By this (sometimes tedious) method, complex queries can be built.  In many cases, however, it may be better to start hacking directly in CoST command language.  Joe is also developing some more powerful builtin search commands :-).

I'm tired, and I expect you are as well...  If you want more tuition, you'll have to wait :-).  I hope it all works - if you find bugs, please let me know.
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return



}

