proc CW::currentTutorial {} {
    global CW

    CW::reset
    
    set msg \
"                            SCRIPTING 
			    (Advanced)

This tutorial is a fairly brief overview of the use of command-line facilities and the costwish scripting language.

We shall use Julius Caesar as the document so you should be familiar with tutorial 2.  (No knowledge of the play is assumed!).  You should also know your way round the costwish interface and make sure that you can read in SGML files.

costwish provides a very powerful scripting facility so that all the commands can be pre-prepared.  If you know that you are going to do repetitive, precise, operations, it's a good idea to use scripts.  (For example, if you wished to do an analysis of all of Shakespeare's plays, you would almost certainly want to write some scripts.
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"
Most operations in the costwish GUI call well-defined procedures and these can either be read in from a script or typed interactively at the command window.  For example, type (or cut-and-paste) the following line in the command line window (at the bottom of the screen) and press return:

	GUI::errorMessage HELP!
  
The procedure (GUI::errorMessage) takes a single argument (a text string), and creates a new window with the message.  tcl and tk have hundreds of commands (all very thoroughly documented, with several text books).  Try:

	puts stdout Hello!

This outputs the string \"Hello!\" to the window where you called costwish from.
(Don't get too ambitious here because we shan't be using this window and there are some quoting rules you have to know - e.g. you need: puts stdout \\\"Hello World!\\\" to use a multiword string.)

Note that you can recall previous successful commands with the up-arrow.
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    set msg \
"

CoST itself consists of a large number of powerful commands to manage your document and they are carefully described in Joe's manual.  Joe wrote CoST to be command-driven because that is the most powerful way of doing complex operations and for many searches you should use his search language directly.  costwish has been written to help you get started by encapsulating some of the commonest commands, and it also gives an introduction to the structure of documents. 


(costwish itself has several hundred proc's to support the GUI.  They weren't originally designed to be called directly by users, but because tcl/tk allows such a nice architecture between graphics and commands, the proc's are usable in their own right. Maybe I'll get around to documenting some of them :-).

The next operation will be to read in the document, so be patient.  The command used in this script is simply:

	SGML::loadDocument SGML \$CW(DEMODIR)/caesar.sgm

where CW(DEMODIR) is simply a variable with the name of the directory that holds the demos.

As the document is read in, look at the status bar at the very bottom of the window and you'll see it announcing that quite a lot of things are going on!  Normally when an operation is completed, this information is cleared.
"

    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    SGML::loadDocument SGML $CW(DEMODIR)/caesar.sgm

    set msg \
"The document should now be loaded in!"

    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
" Just to show you how we can manipulate it, I'll display a node from the script.  The address of PERSONAE is 6:2, so I'll execute the command:
    Node::display \"\" 6:2"

    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    Node::display "" 6:2

    set msg \
"And now I'll undisplay it :-)"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    Node::undisplay 6:2

}

