proc CW::currentTutorial {} {
    global CW

    CW::reset

    if {![info exists CW(TCLDIR,PLAY)] || \
        ![file exists $CW(TCLDIR,PLAY)/local.tcl]} {
        GUI::errorMessage "You need the /play directory for this tutorial"
        return
    }

    set msg \
"In this tutorial we shall examine a large document (Julius Caesar) and explore the ways that costwish allows us to browse it and investigate it.  The 
following tutorial (#3) will demonstrate the search facility.

First, practice reading it in (it might take a minute or so to display).  Select 'File|Load SGML+DTD',  find the /demo directory (probably under cmlcost) and read 'caesar.sgm'.

NOTE:  AFTER I WROTE THIS TUTORIAL I ADDED SOME MORE WINDOW OPTIONS AND THERE MAY BE SOME INCONSISTENCIES.  REFER TO THE MENU HELP - IT'S MORE LIKELY TO BE UP-TO-DATE.
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    if {[SGML::getDTDtype] != "PLAY"} {
        GUI::errorMessage "You didn't manage to read the play in.  Perhaps you should revisit the first tutorial? "
        return
    }
 
    set msg \
"All the Shakespeare plays have been captured and marked up, and I'd like to pay tribute to those who did it.  The credits read:

Text placed in the public domain by Moby Lexical Tools, 1992.
SGML markup by Jon Bosak, 1992-1994.
SoftQuad Panorama stylesheet design by Michael Tabor, 1995.
This work may be freely copied and distributed worldwide.

I did not have a DTD for this but since it appears to be normalised (i.e. 
every tag has a closing tag) and there is no other minimization, it doesn't really need one.  It doesn't use attributes, so it implies that none are missing as defaults.  I have created a trivial DTD to allow it to be processed by SGML but I've since written a DTDless parser and that could be used as well (heresy?).

"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Most of the contents are like this (there are about 6000 lines):

<ACT><TITLE>ACT I</TITLE>

<SCENE><TITLE>SCENE I.  Rome. A street.</TITLE>
<STAGEDIR>Enter FLAVIUS, MARULLUS, and certain Commoners</STAGEDIR>

<SPEECH>
<SPEAKER>FLAVIUS</SPEAKER>
<LINE>Hence! home, you idle creatures get you home:</LINE>
<LINE>Is this a holiday? what! know you not,</LINE>
<LINE>Being mechanical, you ought not walk</LINE>
<LINE>Upon a labouring day without the sign</LINE>
<LINE>Of your profession? Speak, what trade art thou?</LINE>
</SPEECH>

If we simply read this into costwish it would take a minute or two (since costwish is an interpreted system) and the whole screen would mainly consist of <LINE>.  With very little effort we can customise the postprocessor to make it much more attractive.  Before I explain that, however, we'll look at a few builtin rendering options in costwish.
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Notice that we are using a different style (the default) for displaying the Table of Contents (TOC) from what was used in the fisrt tutorial.  We don't show the closing tags or the angle brackets, and we use indentations to show the hierarchy, as in many books.

The first rendering option is that we can hide nodes (or their children).  In the present examplea SPEECH contains many LINEs which, if rendered, would destroy the usefulness of the TOC.  We can therefore instruct costwish not to display LINEs by default.  There is an option (Hide Node) which we could use, but in this case there's a better way.  

The TOC can have any number of levels, but we have set the cutoff at 2.  This
means that only some of the frontmatter, associated material and the ACTs (in the main body) are shown.  Their children are hidden, but could be shown if we increase the level.

Select the 'View' menu and tear it off.  Select  'View |Display Settings'.  This brings up a small window with an option for 'Depth of TOC display'.  It's set to 2.  Try resetting it to 3 (put the cursor in the entry widget and backspace over the '2' and type 3).  Click 'View | Redisplay'.  Note how the children of PERSONAE appear and the SCENEs belonging to the ACTs.  Increase the depth to 4.  Now the children of PERSONAE are quite complex.  (I'll explain SCENEs later). Reset the depth to 3 and redisplay.

"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    

    set msg \
"To display, say, the children of FM (frontmatter), click on the 'FM' node in the TOC.  This brings up the subnode window, where you can see it has 4 subnodes (P=paragraph).  Clicking on each of these in turn reveals the credits (in the Content pane of P).

This is getting very messy (four separate windows to see the credits), and so we'll show you another way in the next frame, more suitable for text than hierarchical structure.

"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Select 'NodeAction | Event display' and then click on FM.  It will fill one of the paned windows, but this time will have the markup associated with the text. (This is essentially just the bit of the original document that corresponds to FM - it may not be pretty, but it's readable.
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"You may have wondered why SCENEs didn't have have children when we dropped to 4 levels.  The children are hidden through another mechanism ('Hide Children'). When an element is likely to have a lot of children, it may be a good idea not to clutter up the TOC to start with.  If you look at 'Hide Children' you'll see that SCENE and FM are checked.  Uncheck SCENE and Redisplay with the levels set to 4.  It may take a LONG TIME (1-5 mins) :-( - now you see why SCENE's children were hidden.

(The original hiding of the children was done in this code from play/local.tcl:

proc PLAY::userInitialise \{\} \{ 
...
    foreach gi \{FM SCENE\} \{
        GI::setHidden \$gi 1 CHILDREN 
    \}

This shows how easy it is to customise costwish.  (We don't expect you to be programmers, and maybe at a later stage I'll make a simple widget that writes this code automatically.)  In fact, howver, I only wrote a small number of lines of code to manipulate the display of PLAY, and this should extend to all the 37 plays that Shakespeare wrote, so the effort is well worth it.)
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"I'm still working out the various ways that nodes may be displayed.  There are several options under 'NodeAction'; the first three toggle between the type of window used (I think 'Expand Subtree' is probably obsolete) and the second three determine what appears in the window.  Play with them to see what you find most useful. I'll be grateful for user feedback on this, since there are many options for combining displays.

Let's look at a larger node, PERSONAE.  It starts like this:

<PERSONAE>
<TITLE>Dramatis Personae</TITLE>

<PERSONA>JULIUS CAESAR</PERSONA>

<PGROUP>
<PERSONA>OCTAVIUS CAESAR</PERSONA>
<PERSONA>MARCUS ANTONIUS</PERSONA>
<PERSONA>M. AEMILIUS LEPIDUS</PERSONA>
<GRPDESCR>triumvirs after death of Julius Caesar.</GRPDESCR>
</PGROUP>


<PGROUP>
<PERSONA>CICERO</PERSONA>

There is clearly some structure here which we might wish to customise.  PGROUP contains a list of PERSONA, but costwish doesn't know this is a list.  There is also a GRPDESCR (which comes at the end).  I would find it most useful to have each PGROUP display its GRPDESCR and then have an indented list of the PERSONAs.
To do this, however, we need to write a bit of code to display PGROUP.  Skip this unless you're interested ...
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"                   PROGRAMMING DETAILS - skip these

play/postproc.tcl contains:

proc PGROUP::formatContents ... (can't display it here)
 
For any tag (FOO) FOO::formatContents will be called for each occurrence, and  here we are using cost to (a) locate a child GRPDESCR (b) get its formatted contents (c) locate all child PERSONAs and append their formatted contents and return the result for the display routine.  In fact, this is called by PERSONAE::display, but there are less than 50 lines of code altogether...)

... we've used this code to display PERSONAs as items in an HTML list , with small formatting additons to GRPDESCR (this could be fonts, but my machine is rather font-dead).
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Now we will display PERSONAE in event stream and as a customised node.  Select 'NodeAction|Paned Nodes'; 'NodeAction|TOC' and click on TOC|'PERSONAE'. The customised node overrides the TOC display and shows that costwish can, with a very little programming, be used as a very powerful renderer including reformatting, reordering and editing and much more.  We are also developing ways of rendering this in print.

We've done the same for SCENE, but with an addition.  You might wish to read the whole, formatted, scene or you might wish to view it as a set of subnodes, each of which is a speech.  Again, we've had to write a little bit of code to display SCENE and within that a switch to allow these options.  A special menu (PLAY) has been automatically create and loaded when you read in the DTD (did you notice?!).  Reset to 'Node Action|Show subtree', click 'PLAY|Scene as subnodes', and now click the first SCENE in the play ('Act I, Scene I').   This is the default costwish approach and shows that there are about 18 SPEECHes.  

If we hadn't customised play/postproc.tcl, each SPEECH would consist of a list of LINEs as subnodes - not very exciting.  So we have customised SPEECH and if you click on the first, you'll see the SPEAKER (FLAVIUS) and the LINEs he speaks. In this way you could read the whole play, speech by speech.

I felt that a SCENE was a mangeable chunk to display all at once, so offered the option 'PLAY|display scene' which you should select.  NOW if you click on the first SCENE in TOC you'll get the whole scene formatted in HTML.  (It will take a little while to display, since the tools are all writeen in *.tcl - this could be vastly speeded up if we wished by translating to C).  You'll see that I have formatted SPEAKER in bold, TITLE with \[...\] and STAGEDIR with ((...)), but fonts, graphics, etc could have been used instead.  (It would be fairly easy to run the LINEs into a speech synthesiser :-( ).  You can now read the whole play in quite a reasonable electronic manner.

Try clicking on ACTs - you will get a manageable list of SCENEs as subnodes, and in this way you could select a few key SCENEs to display at any one time.
"

    Widget::makeDialog $msg CONTINUE QUIT NO
    set CW(TOC,DEPTH) 2
    Toc::display $CW(MAINTOC) $CW(TOC,DEPTH) 1:1

    

    set msg \
"Obviously if there are a large number of children the TOC gets cluttered if we display them all at once, so there is a way of navigating the tree node-by-node.The display has been reset - let's see if we can find the TITLE to ACT II SCENE III.

Go to the second ACT and click on the '+' after it.  This reveals its immediate children (TITLE and 4 SCENEs).  Click on the '+' after the third SCENE.  It should have a TITLE, STAGEDIR, SPEECH, STAGEDIR as children.  Note that TITLE has not children.  We can now click on the TITLE and it appears in a paned node.  Open the Content pane and you should see that the title is 'SCENE III. A street near the Capitol.'

To make this disappear, click on the '-' of any parent (e.g. the second ACT).  All the children and their children recursively vanish.  Have a play with the rest, but note that if you 'Redisplay', then it simply uses the Depth criterion.

"

    Widget::makeDialog $msg CONTINUE QUIT NO

    set msg \
"The last tweak is a simple routine I've written to give more meaningful titles to the tags in the TOC.  Many tags have content, attributes or context which allows us to label them more meaningfully and there is a standard routine that is called for each node (Node::userGetMeaningfulTitle).  By customising this you can label the tags with titles.  For PLAY I have labelled any tags with TITLE children with the contents of that TITLE (see title.tcl for the code - it's very simple).  If you activate 'Meaningful title' button under 'PLAY' you will load this code and next time you 'Redisplay' the TOC (or subnodes) this will label the tags.  Switch it off with the button below it (I'll tidy this some time).
"
    Widget::makeDialog $msg CONTINUE QUIT NO

    set msg \
"This was an illustration of how a conventional book can be cast into similar form electronically.  If that was all that SGML did for us, there would only be a minor benefit.  However,  we can use the raw text in almost infinite ways and the next tutorial (#3) will show you some ways of searching the text for concepts in ways that are impossible on paper.

Remember, also, that Shakespeare is not the only type of electronic information :-).  costwish was developed to manage molecular information, not literature, and it's a credit to SGML and Joe that it can do this as a by-product.  If you have interests in non-textual information you may wish to pursue the XML tutorial which will be distrbuted separately.
"
 Widget::makeDialog $msg CONTINUE QUIT NO
    
}
    

