proc CW::currentTutorial {} {
    global CW

    CW::reset

    set msg \
"Assuming you haven't pressed any other buttons, this is the starting position for CW :-).  I'm going to guide you through some simple concepts.  All you have to do at present is click the 'Continue' button when you have gazed at the screen enough.  
At times there will be quite a few windows on the screen (because documents are complex things!) so you should be familiar with how to move and resize windows."
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Now you can start investigating the menu buttons.  These are 'pull-down' - i.e. they present a menu when Button-1 is depressed over the button.  They are also 'tear-off' since clicking on the dotted line makes the menu a permanent window (it can be killed in whatever way your window manager supports for killing windows.)  Notice that some of the menus (e.g. 'File') have a selection of buttons, whilst others have checkboxes or rdaiobuttons."
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set msg \
"Now we're going to load an SGML file.  First, I'll create a separate window to show you what the file looks like before it's loaded.  (You can get rid of this at any stage by clicking on 'QUIT').  Keep it for a while so you can compare it with what is on the screen.

This is what HTML looks like when it's written according to the SGML standard.
SGML has a complex terminology, and I'll keep it to the minimum.  

HEAD, TITLE, etc are 'generic identifiers' or GIs;  <HEAD> is an opening _tag_ and </HEAD> is a closing tag. HTML _contains_ HEAD, H2, P and UL elements; HEAD _contains_ TITLE; TITLE contains an ASCII string 'CW: Help for File menu' (technically #PCDATA).

First, note the DOCTYPE statement which tells you which DTD has been used.  You _must_ use exactly this DTD in interpreting this file.  (The sgmls system knows where the DTD is through the CATALOG mechanism; we'll try to hide this from you at present.)

Secondly, note that all elements (e.g. HEAD) have opening and closing tags (e.g. <HEAD>...</HEAD>).  Many (most) HTML documents ignore this, and the browsers are usually written to anticipate this, but it isn't strict SGML. (There are some tags like <BR> which don't have content and therefore don't need a closing tag; they are said to be EMPTY.)

Whitespace (e.g. space, tab, carriage return, newline, end-of-line, etc) is often ignored in SGML.  HTML has taken the view (rightly, IMO) that the precise content of whitespace is unimportant and that if you want a line break or a certain number of spaces you must include them explicitly (<BR> or &nbsp;).  (However <PRE> ... </PRE> is used for precise formatting and there whitespace _is_ important.)"
    set file [GUI::displayFile $CW(DOCDIR)/file.html]

    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    set CW(DISPLAY,PEL) 1
    set CW(DISPLAY,CDATA) 1
    set CW(DISPLAY,INDENT) 0
    set CW(DISPLAY,GI) GI
    set CW(TOC,DEPTH) 99
    Toc::display $CW(MAINTOC) $CW(TOC,DEPTH) 1:1

    set msg \
"Now we shall load and process this SGML/HTML file.

Pull-down the 'File' menu (and tear it off if you like).  Click on 'Load SGML+DTD'.
This brings up a file browser.  Navigate until 'costwish' is the current 
open directory and then select 'docs' under 'Directories'.  
You should see a new list under 'Files'.  Select 'file.html' and double-click or press 'OK'.

The tool then automatically:
    Loads in the SGML file (docs/file.html)
    Determines which DTD it requires (in this case HTML 2.0)
    Locates that via the catalog mechanism (SGML_CATALOG)
    Activates sgmls to parse and validate the SGML document.
    Reads the ESIS output from SGMLS
    Presents this on the screen as a 'Table of Contents'
    Returns control to you!

If you don't follow all of this, don't worry.  The main message is that the process is automatic and robust.  IF you get error messages, you should try to work out what has gone wrong (see 'Help'|'Debugging Hints').

The next dialog tells you about the Table of Contents"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    if {$CW(DOCUMENT,FILENAME) != "$CW(DOCDIR)/file.html"} {
        SGML::loadDocument SGML $CW(DOCDIR)/file.html 
        set msg \
"You didn't load the file, so I've done it for you :-)"
        if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return
    }


    set msg \
"This is a rendering of how the SGML(HTML) file is translated by sgmls and stored internally.  
It's very similar to the HTML file we input, except for layout.  There are many
ways of rendering this, such as indenting each containing tag as we now show.
Pull down the 'View' menu and click 'Indent Nodes'  (you should now see a coloured box against it).  Then click 'Redisplay'.

You'll see that the start tags are staggered, which gives and idea of which tags contain which other ones.  Note partcularly how <UL> (unnumbered list) contains the <LI> (list items) tags.

There are a number of more advanced display options under 'View' and you should click on 'Show Addresses' and redisplay.  Notice how each start tag has a numeric address (e.g. <TITLE> is 1:3).  Don't try to work this out (Joe mentions the basis in the CoST manual) since some nodes (e.g. PEL) are not displayed.  (PEL and CDATA are not for beginners.)  The important concept is that each start tag is a _node_ which has a unique address.

Now we 'll see how this might be rendered by an HTML-aware tool.  We have built in Stephen Uhler's html_library for the display of hypertext, and you'll now see the result of feeding the SGML/HTML file to it
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} return

    catch "destroy $file"
    set file [GUI::displayFile $CW(DOCDIR)/file.html HTEXT]
    set CW(DISPLAY,PEL) 1
    set CW(DISPLAY,CDATA) 1
    set CW(DISPLAY,INDENT) 0
    set CW(DISPLAY,GI) GI
    Toc::display $CW(MAINTOC) $CW(TOC,DEPTH) 1:1

    set msg \
"(I've reset the screen rendering, and deleted one of the windows :-).
If you compare the hypertext to the rendering, you'll see how (say) LI is rendered by a red circle (this is entirely arbitrary).  IT'S CRITICAL TO REALISE THAT ALL THE RENDERING IS CONTAINED IN THE html_library CODE AND THAT THERE HAS TO BE CODE FOR EACH TAG.
"
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} {
        catch "destroy $file"
        return
    }

    set CW(DISPLAY,INDENT) 1
    Toc::display $CW(MAINTOC) $CW(TOC,DEPTH) 1:1
    set msg \
"           NODES and EVENT STREAMS.

There are many ways of regarding SGML documents (see the intro to Goldfarb's book) but two are particular useful for costwish.
The indentation shows how BODY contains H2, P, UL, and we say that the BODY node _contains_ three child nodes.  Similarly UL contains several LI nodes (grandchildren of BODY).  The first LI node has several _younger siblings_.  costwish supports this approach (see Joe's manual) and knows what the relationship is between nodes.

Notice, however, that this is not such a useful way of describing TT for which the _event stream_ terminology is better.  Here we imagine traversing the whole document in the natural order, and every time we come to a tag we switch comething on or off.  In this case, when we find a <TT> we switch ON courier font (say) and when we reach </TT>, we switch it off again.  

Whether nodes or event stream are the best approach depends on our semantic view of the document.  If we want to use both in the rendering, we have to know what actions to perform for each event, and I'm working on how costwish can be customised to do this.

The next screen will describe how nodes are rendered."
    
    if {[Widget::makeDialog $msg CONTINUE QUIT NO] == "QUIT"} {return}

    catch "destroy $file"

    set msg \
"Now lets see how a node is displayed in costwish.  click (button-1) on <BODY>.
A new window appears called .body2z2, which tells you its GI (BODY) and its
address (2:2).  There are three children: H2, P and UL.  Click on UL.

Yet another window appears.  (This can get cluttered, so I've given you some
navigation.  The container is highlighted in yellow on the TOC.  If you click on 'Locate Text' of any window it will find the correpsonding place in the text, shifting the scroll if required.  If you want to know the _parent_ of a window, click on 'Parent' and it raise the parent window to visibility (creating it if necessary).  It will try to flash part of it to catch your eye.

A NODE can not only contain other nodes, but also have CONTENT and ATTRIBUTES.  As as example, navigate to one of the LI nodes (either from the UL window, or from the TOC) and open its window.  You will see that it has no child nodes, but it has 'SDAFORM: LItem', then a bar, and then some more text.  Note that if you destroy a node window (e.g. BODY) by clicking on QUIT, all the child node windows will also be destroyed.  (BTW, destroying windows will not affect the file or the stored ESIS stream; costwish is just a renderer at present.)

The first string (SDAFORM) is an attribute whose value is LItem.  (SDA is a means of labelling the document for rendering in Braille or other ways). The SDAFORM attributen was NOT in the original SGML file and has been added as a default by the DTD.  In most cases attributes are added by the document's creators (e.g. iin '<IMG SRC=\"fig.gif\">', SRC is an attribute of IMG.

The second string is the CONTENT of the node.  Only certain nodes (those with #PCDATA in the DTD) can have content.

You will see that it's not easy to read the whole document structured as nodes, but it's also difficult to get a feel for the structure if all nodes were rendered as an event stream (e.g. by changing colour, font, etc).  For that reason, most users of costwish will want to develop a postprocessor for their favorite DTDs.

That's enough for now :-)
"

    Widget::makeDialog $msg CONTINUE QUIT NO
}
    

