# Tix Demostration Program
#
# This sample program is structured in such a way so that it can be
# executed from the Tix demo program "widget": it must have a
# procedure called "RunSample". It should also have the "if" statment
# at the end of this file so that it can be run as a standalone
# program using tixwish.

# This file demonstrates how to use multiple columns and multiple styles
# in the tixHList widget
#
# In a tixHList widget, you can have one ore more columns. 
#

proc RunSample {w} {

    # We create the frame and the ScrolledHList widget
    # at the top of the dialog box
    #
    frame $w.top -relief raised -bd 1

    # Put a simple hierachy into the HList (two levels). Use colors and
    # separator widgets (frames) to make the list look fancy
    #
    tixScrolledHList $w.top.a -options {
	hlist.columns 3
    }
    pack $w.top.a -expand yes -fill both -padx 10 -pady 10 -side left


    # This is our little relational database
    #
    set bosses {
	{jeff  "Jeff Waxman"	Director}
	{john  "John Lee"	Manager}
	{peter "Peter Kenson"	Manager}
    }

    set employees {
	{alex	john 	"Alex Kellman"		Clerk}
	{alan	john 	"Alan Adams"		Clerk}
	{andy	peter 	"Andreas Crawford"	Salesman}
	{doug	jeff  	"Douglas Bloom"		Clerk}
	{jon	peter	"Jon Baraki"		Salesman}
	{chris	jeff	"Chris Geoffrey"	Clerk}
	{chuck	jeff	"Chuck McLean"		Cleaner}
    }

    set style(boss_name) [tixItemStyle text -fg #202060 \
	-selectforeground  #202060 \
	-font [tix option get bold_font ]]
    set style(boss_posn) [tixItemStyle text -fg #202060 \
	-selectforeground  #202060]

    set style(empl_name) [tixItemStyle text -fg #602020 \
	-selectforeground  #602020  \
	-font [tix option get bold_font ]]
    set style(empl_posn) [tixItemStyle text -fg #602020 \
	-selectforeground  #602020 ]

    set hlist [$w.top.a subwidget hlist]

    # Let configure the appearance of the HList subwidget 
    #
    $hlist config -separator "." -width 25 -drawbranch 0 -indent 10
    $hlist column width 0 -char 20

    set index 0
    foreach line $bosses {
	set row [$hlist add [lindex $line 0] -itemtype text \
	    -text [lindex $line 1] -style $style(boss_name)]
	$hlist item create $row 1 -itemtype text -text [lindex $line 2] \
	    -style $style(boss_posn)
	incr index
    }

    foreach line $employees {
	# "." is the separator character we chose above
	#
	set entrypath [lindex $line 1].[lindex $line 0]
	#             ^^^^^^^^^^^^^^^   ^^^^^^^^^^^^^^^
	#	      parent entryPath / child's name

	set row [$hlist add $entrypath -text [lindex $line 2] \
	    -style $style(empl_name)]
	$hlist item create $row 1 -itemtype text -text [lindex $line 3] \
	    -style $style(empl_posn)

	# [Hint] Make sure the [lindex $line 1].[lindex $line 0] you choose
	#	 are unique names. If you cannot be sure of this (because of
	#	 the structure of your database, e.g.) you can use the
	#	 "addchild" widget command instead:
	#
	#  $hlist addchild [lindex $line 1] -text [lindex $line 2]
	#                  ^^^^^^^^^^^^^^^^
	#                  parent entryPath 

    }

    # Use a ButtonBox to hold the buttons.
    #
    tixButtonBox $w.box -orientation horizontal
    $w.box add ok     -text Ok     -underline 0 -command "destroy $w" \
	-width 6
    $w.box add cancel -text Cancel -underline 0 -command "destroy $w" \
	-width 6

    pack $w.box -side bottom -fill x
    pack $w.top -side top -fill both -expand yes
}


# This "if" statement makes it possible to run this script file inside or
# outside of the main demo program "widget".
#
if {![info exists tix_demo_running]} {
    wm withdraw .
    set w .demo
    toplevel $w
    RunSample $w
}

