set tix_demo_running 1

set sample_types {widget image}

set sample_comments(widget) "Widget Demostrations"
set sample_comments(image) "Image Demostrations"

set samples(widget) {
    {Balloon			Balloon.tcl}
    {ButtonBox			BtnBox.tcl}
    {ComboBox			ComboBox.tcl}
    {Control			Control.tcl}
    {"Drag and Drop"		DragDrop.tcl}
    {DirList			DirList.tcl}
    {DirTree			DirTree.tcl}
    {ExFileSelectDialog		EFileDlg.tcl}
    {FileSelectDialog		FileDlg.tcl}
    {FileEntry			FileEnt.tcl}
    {"HList"			HList1.tcl}
    {LabelEntry			LabEntry.tcl}
    {LabelFrame			LabFrame.tcl}
    {NoteBook			NoteBook.tcl}
    {OptionMenu			OptMenu.tcl}
    {PanedWindow		PanedWin.tcl}
    {PopupMenu			PopMenu.tcl}
    {"ScrolledHList (1)"	SHList.tcl}
    {"ScrolledHList (2)"	SHList2.tcl}
    {ScrolledListBox		SListBox.tcl}
    {ScrolledText		SText.tcl}
    {ScrolledWindow		SWindow.tcl}
    {Select			Select.tcl}
    {StdButtonBox		StdBBox.tcl}
}

set samples(image) {
    {"Compound Image"	CmpImg.tcl}
}

proc MkSample {nb page} {
    global tixOption
    set w [$nb subwidget $page]

    set name [tixOptionName $w]
    option add *$name*TixLabelFrame*label.padX 4

    label $w.lab  -text "Select a sample program:" -anchor w
    label $w.lab1 -text "Source:" -anchor w

    tixScrolledHList $w.slb \
	-options {
	    listbox.exportSelection 0
	}

    $w.slb subwidget hlist config -command "Sample:Action $w $w.slb run" \
	-browsecmd "Sample:Action $w $w.slb browse" 

    tixScrolledText $w.stext
    set text [$w.stext subwidget text]
    bind $text <1> "focus %W"
    bind $text <Up>    "%W yview scroll -1 unit"
    bind $text <Down>  "%W yview scroll 1 unit"
    bind $text <Left>  "%W xview scroll -1 unit"
    bind $text <Right> "%W xview scroll 1 unit"
    bind $text <Tab>   {focus [tk_focusNext %W]; break}

    bindtags $text "$text Text [winfo toplevel $text] all"

    button $w.run  -text "Run ..."  -command "Sample:Action $w $w.slb run"
    button $w.view -text "View Source in Browser ..." \
	-command "Sample:Action $w $w.slb view"


    tixForm $w.lab -top 0 -left 0 -right &$w.slb
    tixForm $w.slb -left 0 -top "$w.lab" -bottom -4

    tixForm $w.lab1 -l &$w.stext -t 0 -r &$w.stext \
	-b $w.stext

    tixForm $w.run  -left "$w.slb 30" -bottom -4
    tixForm $w.view -left $w.run -bottom -4

    tixForm $w.stext -bottom "$w.run -5" -left &$w.run \
	-right -0 -top &$w.slb

    $w.stext subwidget text config -bg [$w.slb subwidget hlist cget -bg] \
	-state disabled -font $tixOption(courier_font) -wrap none
    
    global samples sample_types sample_comments
    set hlist [$w.slb subwidget hlist]
    $hlist config -separator "." -width 25 -drawbranch 0 -indent 10 \
	-wideselect true


    set style [tixItemStyle text -fg #202060 -padx 4]
    set index 0
    foreach type $sample_types {
	if {$index != 0} {
	    frame $hlist.sep$index -bd 2 -height 2 -width 150 -relief sunken \
		-bg [$hlist cget -bg]
	    $hlist addchild {} -itemtype window \
		-window $hlist.sep$index -state disabled 
	}
	set p [$hlist addchild {} -itemtype text\
	    -text $sample_comments($type) -state disabled -style $style]
	foreach sample $samples($type) {
	    $hlist addchild $p -itemtype text \
		-data $sample -text [lindex $sample 0]
	}
	incr index
    }

    $hlist select clear

    $w.run  config -state disabled
    $w.view config -state disabled
}

set sample_filename {}

proc Sample:Action {w slb action args} {
    global samples demo_dir

    set hlist [$slb subwidget hlist]
    set anchor [$hlist info anchor]
    if {$anchor == ""} {
	$w.run  config -state disabled
	$w.view config -state disabled
	return
    }
    if {[$hlist info parent $anchor] == {}} {
	# This is just a comment
	return
    }
    $w.run  config -state normal
    $w.view config -state normal

    set theSample [$hlist info data $anchor]
    set title [lindex $theSample 0]
    set prog  [lindex $theSample 1]

    set samples_dir $demo_dir/samples

    case $action {
	"run" {
	    set w .[lindex [split $prog .] 0]
	    set w [string tolower $w]

	    if [winfo exists $w] {
		wm deiconify $w
		raise $w
		return
	    }

	    uplevel #0 source $samples_dir/$prog

	    toplevel $w 
	    wm title $w $title
	    RunSample $w
	}
	"view" {
	    set w .[lindex [split $prog .] 0]_source
	    set w [string tolower $w]

	    if [winfo exists $w] {
		wm deiconify $w
		raise $w
		return
	    }

	    toplevel $w 
	    wm title $w "Source View: $samples_dir/$prog"
	    LoadFile $w $samples_dir/$prog
	}
	"browse" {
	    # Bring up a short description of the sample program
	    # in the scrolled text about

	    set text [$w.stext subwidget text]
	    uplevel #0 set sample_filename $samples_dir/$prog
	    tixWidgetDoWhenIdle ReadFileWhenIdle $text
	}
    }
}

proc LoadFile {w filename} {
    global tixOption

    button $w.b -text Close -command "destroy $w"
    set t [tixScrolledText $w.text]
    tixForm $w.b    -left 0 -bottom -0 -padx 4 -pady 4
    tixForm $w.text -left 0 -right -0 -top 0 -bottom $w.b

    $t subwidget text config -highlightcolor [$t cget -bg] -bd 2 \
	-bg [$t cget -bg] -font $tixOption(courier_font) 
    if {$filename == {}} {
	return
    }

    set text [$w.text subwidget text]
    $text config -wrap none

    ReadFile $text $filename
}

proc ReadFileWhenIdle {text} {
    global sample_filename
    
    ReadFile $text $sample_filename
}

proc ReadFile {text filename} {
    set oldState [$text cget -state]
    $text config -state normal
    $text delete 0.0 end

    catch {
	set fd [open $filename {RDONLY}]
	$text delete 1.0 end

	while {![eof $fd]} {
	    $text insert end [gets $fd]\n
	}
	close $fd

	
    }

    $text see 1.0
    $text config -state $oldState
}
