#========================================================================
# miscellaneous - not really part of formal distribution yet
#========================================================================
proc Node::userGetMeaningfulTitle {{address ""}} {

# this depends on the ELEMENTs in the DTD and their attributes
# This is for XML and CML.  WE go through the attnames and look
# for anything that might be useful.
    set attnames {SECTION TITLE NAME STATUS HREF BUILTIN TYPE}
    set string ""
    
    withNode node [Node::getAddress $address] {
        foreach attname $attnames {
            set string [query attval $attname]
            if {$string == "UNK"} {set string ""}
            if {$string != ""} break
        }
    }
# this relates to anything within HREF from a cgi service (truncate before ?):
    regsub {.*[\?](.*)} $string "\\1" string

# get the GI
    set gi [query gi]

# for X.VAR give the content
    if {$string == "" && $gi == "X.VAR"} {
        set string [string range [content] 0 29]
    }

# if gi is X.LIST, use the 'TYPE' field
    if {$gi == "X.LIST" && $string == ""} {
        set string [query attval TYPE]
    }

# if gi is SECT use contents of TITLE (costdoc)
    if {$gi == "SECT"} {
        withNode node [Node::getAddress $address] child withgi TITLE {
            set string [content]
        }
    }

# truncate long strings
    if {[string length $string] > 30} {
        set string [string range $string 0 29]
    }
    return $string
}


#------------------------------event handlers----------------------------
# messy.  better if the initialisation routines for mol.tcl set up the
# handlers and a generic routine deals with them.

# tests a list of possible context and returns 1 if it finds an
proc X.ARR::userEventHandler {address items} {

puts "X.ARR::userEventHandler::$items"
# is it part of a molecule?
    withNode node $address ancestor withgi C.AT {
        foreach builtin {RESNAM RESNO CHAIN} {
            withNode child withgi X.ARR withattval BUILTIN $builtin {
                set array [X.ARR::getElements [q address]]
                foreach item $items {
                    set temp($builtin,$item) [lindex $array $item]
                }
            }
        }
        set command ""
        set count 0
        foreach item $items {
            append command \
                "$temp(RESNAM,$item)$temp(RESNO,$item)$temp(CHAIN,$item).ca,"
            incr count
            if {$count == 7} {
                set count 0
                regsub {\,$} $command "" command
                regsub {[ ]*} $command "" command
                sendRasmolCommand "select $command"
                sendCurrentRasmolSettings
                set command ""
            }
        }
        if {$command != ""} {
            regsub {\,$} $command "" command
            regsub {[ ]*} $command "" command
            sendRasmolCommand "select $command"
            sendCurrentRasmolSettings
        }
        return 1
    }
# report the value (don't do anything at present ..."
    puts stdout "Values of points picked sent to event handler"
    set contents [X.ARR::getElements $address]
    foreach item $items {
        puts stdout "item $item: [lindex $contents $item]"
    }
    return 1

    return 0
}

# this is called (from html_library) when there is a hit on a HREF tag
proc HTML::userLinkCallback {win href} {

# internal to the SGML file?
    if {[string first "#" $href] == 0} {
        set target [getNodeAddressForInternalTarget $href]
        withNode node $target ancestor elements \
            "X.BIB X.FIG X.HTML X.LIST C.MOL" {
            set address [query address]
            Node::display $win $address
        }
# ismap? (collects coords without an href)
    } elseif {[regexp {(.*)[\?]([0-9]*),([0-9]*)} $href junk address x y]} {
        set gi [query node $address gi]
        if {$gi == "Error"} return
        if {[info proc $gi::processISMAP] == ""} {
            errorMessage "No $gi::processISMAP: cannot process clickable map"
        } else {
            eval $gi::processISMAP $address $x $y
        }
    } elseif {[regexp -nocase "GLOSSARY:(.*)" $href junk glossref]} {
        Glossary::showEntry $glossref
    }
}



