#========================================================================
# HTML-related initialisation
#========================================================================

puts "Reading html/local.tcl"

# this sets defaults related to the HTML tags
proc HTML::userInitialise {} {
    global CW

# GI colours
    set CW(COLOR,GI,HEAD) grey

# browser to use
    set CW(BROWSER,EXE) mosaic

}

#-------------------------------------------------------------------------

# replaces < by &lt; etc for viewing in HTML
proc HTML::escapeDelimiters {content} {

    regsub -all {<} $content {\&lt;} content
    regsub -all {>} $content {\&gt;} content
    regsub -all {\&lt;\/} $content {<BR>\&lt;/} content
    return $content
}

# helper browser
proc HTML::display {file} {
    global CW

    set anchor ""
# might be of form abc.html#anchor
    regexp "(.*)#(.*)" $file junk file anchor
# use html_library
    GUI::displayFile $file HTEXT $anchor
    return

# ... this stuff is how you might link with other browsers ...

    if {![info exists CW(BROWSER,PID)]} {
        set CW(BROWSER,PID) 0
    }
    if {$CW(BROWSER,PID) != 0} {
        catch "exec kill -15 $CW(BROWSER,PID)"
    }
    GUI::postStatus "Launching HTML browser"
    set CW(BROWSER,PID) [exec $CW(BROWSER,EXE) $file &]
    after 2
    GUI::postStatus ""
}

puts "... end of html/local.tcl"

