#!

global env argv CW

#option add *Label.background blue startup

# setup file (includes key envvars, and helpers)
if {![info exists env(CWDIR)]} {
    puts stderr "ERROR: You must set environment variable CWDIR (see setup.csh)"
    exit
}
source $env(CWDIR)/costwishini.tcl

# the HTML library.  It has to be here (I have no idea why).  Else I get
# very unpleasant and totally unclear bugs.  (it *may* be because of
# global variables).

if {![info exists CW(LIBDIR)]} {
    GUI::errorMessage "You must set CW(LIBDIR) (see costwishini.tcl)" 
    exit
}
source $CW(LIBDIR)/html_library.tcl

#-------------------------------INITIALISE----------------------------------

proc CW::initialise {} {
    global CW argv

# this allows the user to add additional CW initialisation, though this
# is not recommended until you understand the system well...
    CW::userInitialise

# HTML is a builtin part of CW
    SGML::loadPostprocessor HTML

# must initialise SGML
    SGML::initialise

    Output::setLanguage HTML
    Output::initialise
    Output::format INITIALISE

# don't display these by default
    set CW(DISPLAY,ADDRESS) 0
    set CW(DISPLAY,NODETYPE) 0

    set CW(DOCUMENT,FILENAME) ""

# check for versions of costwish

    if {[info commands tix] == ""} {
        puts stdout "*** COSTWISH has no: TiX widget set***"
        puts stdout \
             "    The display would be better and include a file browser"
    }

# windows, widgets, stc
    set CW(BUTTON,HEIGHT) 20
}

# tries to return the system to its original state.  Not yet watertight!!
proc CW::reset {} {
    global CW
    catch "$CW(MAINTOC) delete 1.0 end"
    SGML::loadDocument ESIS $CW(CWDIR)/null.esis
    set CW(DOCUMENT,FILENAME) ""
}

#------------------------------------------------------------------------
# this is a subsidiary menu to which the user can add local items
proc CW::makeMenus {} {
    global CW
    set menuItems {\
        {command Help "HTML::display $CW(DOCDIR)/user.html"} \
        {command "Display Log" Log::display} \
    }
    set menuItems [CW::addMenuItems $menuItems]
    GUI::makeMenu .bar.user "User Options" "" "-side left" $menuItems
}

#------------------------------------------------------------------------
proc CW::simpleWindow {{file ""}} {
# if called with file, attempts to load it as an SGML or ESIS file
    global CW

    wm minsize . 700 300
    wm maxsize . 950 700
    frame .bar
    pack .bar -fill x
    
    GUI::makeMenu .bar.file "File     " "" "-side left" { \
        {command Help "HTML::display $CW(DOCDIR)/file.html"} \
        {command Redisplay "Toc::display $CW(MAINTOC) $CW(TOC,DEPTH) 1:1"} \
        {command "Load ESIS" "SGML::loadDocument ESIS"} \
        {command "Load Norm-SGML" "SGML::loadDocument NORM"} \
        {command "Load SGML+DTD" "SGML::loadDocument SGML"} \
        {command "Save as ESIS" "SGML::writeFile ESIS"} \
        {command "Save as SGML" "SGML::writeFile SGML"} \
        {command "Save as HTML" "SGML::writeFile HTML"} \
        {command Reset CW::reset} \
        {command QUIT CW::quit}
    } 
    
# this alters visibility of node properties and redisplays 
    GUI::makeMenu .bar.view "View     " "" "-side left" { \
        {command Help "HTML::display $CW(DOCDIR)/view.html"} \
        {command "Display Settings" "CW::settings"} \
        {checkbutton "Show Addresses" CW(DISPLAY,ADDRESS) 0 \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {checkbutton "Show NodeType" CW(DISPLAY,NODETYPE) 0 \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {checkbutton "Show PEL nodes" CW(DISPLAY,PEL) 0 \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {checkbutton "Show CDATA nodes" CW(DISPLAY,CDATA) 0 \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {checkbutton "Show Text Content" CW(DISPLAY,CONTENT) 0 \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {checkbutton "Indent nodes" CW(DISPLAY,INDENT) 1 \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {checkbutton "AutoRedisplay" CW(DISPLAY,AUTO) 0 \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {radiobutton "Show GI" CW(DISPLAY,GI) GI \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {radiobutton "Show TITLE" CW(DISPLAY,GI) TITLE \
            "-command \"Toc::autoRedisplay \\$CW(MAINTOC) 1:1\""} \
        {command Redisplay "Toc::display $CW(MAINTOC) $CW(TOC,DEPTH) 1:1"} 
    } 
    set CW(TOC,DEPTH) 2
    set CW(NODE,DEPTH) 4
    set CW(DISPLAY,INDENT) 1
    set CW(DISPLAY,GI) TITLE

    GUI::makeMenu .bar.search "Search  " "" "-side left" { \
        {command Help "HTML::display $CW(DOCDIR)/search.html"} \
        {command "Search/UCs" Search::topWindow} \
        {command "UserClasses" UserClass::manipulate}
    }

    GUI::makeMenu .bar.node "NodeAction" "" "-side left" { \
        {command Help "HTML::display $CW(DOCDIR)/nodes.html"} \
        {separator "" ""} \
        {label "Types of window" ""} \
        {separator "" ""} \
        {radiobutton "Paned Nodes" CW(NODEACTION) PANED} \
        {radiobutton "Windowed Nodes" CW(NODEACTION) SUBTREE} \
        {radiobutton "Expand Subtree" CW(NODEACTION) EXPAND} \
        {separator "" ""} \
        {label "Types of display" ""} \
        {separator "" ""} \
        {radiobutton "TOC Display" CW(NODEDISPLAY) TOC} \
        {radiobutton "Tree Display" CW(NODEDISPLAY) TREE} \
        {radiobutton "Event Display" CW(NODEDISPLAY) EVENT} \
        {separator "" ""} \
        {label "Unused options" ""} \
        {separator "" ""} \
        {radiobutton "Select Node" CW(NODEACTION) SELECT "-state disabled"} 
        {radiobutton "Delete Node" CW(NODEACTION) DELETE "-state disabled"} 
        {radiobutton "Add Node" CW(NODEACTION) ADD "-state disabled"} 
        {radiobutton "Edit Node" CW(NODEACTION) EDIT "-state disabled"} 
    }
    set CW(NODEACTION) PANED
    set CW(NODEDISPLAY) TOC

    CW::makeMenus

    GUI::makeMenu .bar.help "    Help" "" "-side right" { \
        {command "About Help" "HTML::display $CW(DOCDIR)/abouthelp.html"} 
        {command "Overview" "HTML::display $CW(DOCDIR)/overview.html"} 
        {command "Debugging Hints" "HTML::display $CW(DOCDIR)/debug.html"} 
        {command "Terminology" "HTML::display $CW(DOCDIR)/terms/_glossary.html"} 
        {command "CoST Manual" "GUI::displayFile $CW(DOCDIR)/costmanual.txt"} 
        {command "sgmls manPages" "GUI::displayFile $CW(DOCDIR)/sgmls.txt"} 
        {command "Tix HTML pages" "HTML::display $CW(DOCDIR)/tix/README.html"} 
        {command "BLT demo" "exec costwish $CW(DOCDIR)/blt/demos/graph1"}
        {command "Hippo html_library" "GUI::displayFile $CW(DOCDIR)/hippo.txt"}
        {command "About COSTWISH" "HTML::display $CW(DOCDIR)/costwish.html"} 
        {command "About CMLCOST" "HTML::display $CW(DOCDIR)/cmlcost.html"} 
    }
    
# bar for info (DTD and file names)
    frame .info
    pack .info -fill x
    set text(dtd) "DTD:"
    set width(dtd) 10
    set text(file) "File:"
    set width(file) 50
    foreach widget {dtd file} {
        label .info.$widget -text "$text($widget)"
        pack .info.$widget -side left
        label .info.${widget}val -text "" -width $width($widget)
        pack .info.${widget}val -side left
    }

# make commandline
    CommandLine::construct .comm

# this doesn't work yet.  Maybe better to source prepared scripts?
    button .comm.b -text "Script" -command "displayCommandScript .script"
    .comm.b configure -state disabled
    pack .comm.b -side left

# make hypertext window and side windows
    set mainFrame [Widget::makeOrRenew frame .mainframe]
    pack $mainFrame -side top -expand yes -fill both
    set panes [Tix::makePane $mainFrame.panes {{toc 300} side} horizontal]
    
    set CW(MAINTOC) [lindex $panes 0].text
    set CW(SIDEWIN,CURRENT) 0
    set CW(SIDEWIN) [Widget::makeOrRenew frame [lindex $panes 1].side]
    pack $CW(SIDEWIN) -expand yes -fill both

    set panelist ""
    set CW(SIDEWIN,NUMB) 3
    for {set i 0} {$i < $CW(SIDEWIN,NUMB)} {incr i} {
        lappend panelist [list pane$i 25 150]
    }
    set side [Tix::makePane $CW(SIDEWIN).f $panelist vertical]
    for {set i 0} {$i < $CW(SIDEWIN,NUMB)} {incr i} {
        set CW(SIDEWIN,$i) [Widget::makeOrRenew frame [lindex $side $i].frame]
        pack $CW(SIDEWIN,$i) -side top -expand yes -fill both
    }
    
    update

#    set nwin 3
#    for {set i 0} {$i < $nwin} {incr i} {
#        lappend panelist [list side$i 50]
#    }
#    set side [Tix::makePane $CW(SIDEWIN).panes $panelist vertical]
#    pack $CW(SIDEWIN).panes -side top -expand yes
#    for {set i 0} {$i < 3} {incr i} {
#        set frame [Widget::makeOrRenew text [lindex $side $i].frame]
#        pack $frame -side top -expand yes 
#    }
# clear status window
    GUI::postStatus ""

# read file if in arguments
    if {$file != ""} {
        GUI::postStatus "Loading SGML/ESIS file"
        SGML::loadDocument UNK $file
    }
}

# updates info about DTD, file
proc CW::updateInfoBar {type text} {
    .info.${type}val configure -text $text
}

proc CW::quit {} {

    CW::deleteTempFiles
    CW::deletePIDs
    exit
}

#-------------------------------Toc Settings------------------------------
proc CW::settings {} {
    global CW
    set frame [Widget::makeOrRenew toplevel .settings]

    set tocFrame [Widget::makeOrRenew frame $frame.toc]
    pack $tocFrame
    set label [Widget::makeOrRenew label $tocFrame.lab]
    $label configure -text "Depth of TOC display"
    pack $label -side left
    set entry [Widget::makeOrRenew entry $tocFrame.ent]
    $entry configure -textvariable CW(TOC,DEPTH)
    pack $entry -side left

    set nodeFrame [Widget::makeOrRenew frame $frame.node]
    pack $nodeFrame
    set label [Widget::makeOrRenew label $nodeFrame.lab]
    $label configure -text "Depth of Node display"
    pack $label -side left
    set entry [Widget::makeOrRenew entry $nodeFrame.ent]
    $entry configure -textvariable CW(NODE,DEPTH)
    pack $entry -side left

}
    
#-----------------------------------PIDs----------------------------------
proc CW::deletePIDs {} {
    global CW
    if {[info exists CW(PIDS)]} {
        foreach pid $CW(PIDS) {
            puts "Killing process: $pid"
            catch "exec kill -15 $pid"
        }
    }
}

proc CW::addPID {pid} {
    global CW
    lappend CW(PIDS) $pid
}

#------------------------------temporary files----------------------------

proc CW::deleteTempFiles {} {
    global CW
    if {[info exists CW(TEMPFILES)]} {
        foreach file $CW(TEMPFILES) {
            if {[file exists $file]} {
                puts "Deleting temporary file: $file"
                catch "exec rm $file"
            }
        }
    }
}

proc CW::addTempfile {file} {
    global CW
    lappend CW(TEMPFILES) $file
}

proc CW::existsTempfile {file} {
    global CW
    if {[info exists CW(TEMPFILES)] && [lsearch $CW(TEMPFILES) $file] != -1} {
        return 1
    }
    return 0
}

#-------------------------------------------------------------------------

proc CW::processArgs {} {
    global argv CW

    set CW(DOCUMENT,DISPLAY) 1 
    set l [llength $argv]
    for {set i 0} {$i < $l} {incr i} {
        set arg [string tolower [lindex $argv $i]]
        incr i
        if {$arg == "-nodocument"} {
            set CW(DOCUMENT,DISPLAY) 0
        }
    }
}

#-------------------------------------------------------------------------
# these routines can be overwritten (overloaded) by the local versions
# in cw_local.tcl
proc CW::userInitialise {} {}
proc CW::addMenuItems {menuItems} {return $menuItems}
proc CW::userScript {} {}

#---------------------------------INITIALISE------------------------------

    CW::processArgs
    
    source $CW(CWDIR)/cwlib.tcl
# assuming we are in graphical mode...
    source $CW(CWDIR)/gui.tcl
    
# this adds support for additional DTDs, local environment, etc
    source $CW(CWDIR)/customisation.tcl
    
    CW::initialise
    CW::simpleWindow [lindex $argv 0]
    
    CW::userScript
    
    
