#========================================================================
# THIS FILE MUST BE PRESENT : It customises the HTML DTD and adds in
# any others.  YOU WILL NEED TO EDIT BITS IF YOU WANT YOUR OWN ROUTINES
#========================================================================

puts "Reading customisation.tcl..."

#=================================CW=====================================
#=================================CW=====================================

    global CW env

    if {[file exists $CW(CWDIR)/cw_local.tcl]} {
        source $CW(CWDIR)/cw_local.tcl
    }

#=================================CW=====================================
#=================================CW=====================================

# where are the *.html files stored? (should be standard)
    set CW(DOCDIR) $CW(COSTWISH)/docs

# the demonstrations?
    set CW(DEMODIR) $CW(COSTWISH)/demos

# the user's *.tcl routines?
    set CW(USERDIR) $CW(COSTWISH)/user

#===============================LIBRARY==================================

    set CW(TCLDIR,_LIBRARY) $CW(CWDIR)/library

#==============================HTML DTD==================================
#==============================HTML DTD==================================

    set CW(TCLDIR,HTML) $CW(CWDIR)/html

#==============================PLAY DTD==================================

    set CW(TCLDIR,PLAY) $CW(USERDIR)/play

#===========================COSTDOC DTD==================================

    set CW(TCLDIR,COSTDOC) $CW(USERDIR)/costdoc

#========================================================================
# ADD IN ADDITIONAL DTDs (WILL NEED EDITING FOR YOUR DTDs)
#========================================================================
    
#===============================CML DTD==================================
#===============================CML DTD==================================

    if {[info exists env(CMLDIR)]} {
        set CW(CMLDIR) $env(CMLDIR)
        set CW(CMLTCL) $CW(CMLDIR)/cmlcost
        set CW(TCLDIR,CML) $CW(CMLTCL)/cml

#===============================XML DTD==================================
#===============================XML DTD==================================

        set CW(TCLDIR,XML) $CW(CMLTCL)/xml
# glossary directory root
        global XML
        set XML(GLOSSARY,DIRECTORY) $CW(CMLDIR)/glossary

#===============================MOL DTD==================================

        set CW(TCLDIR,MOL) $CW(CMLTCL)/mol
    }

#=============================MARTIF DTD=================================

    if {[info exists env(MARTIFDIR)]} {
        set CW(TCLDIR,MARTIF) $env(MARTIFDIR)/costwish
    }

#========================================================================
# DON'T EDIT BELOW THIS LINE.  IT'S NOT REALLY USED ...
#========================================================================
# POST-DTD routines.  The following routines are 'derived' from the CW
# code and cannot be coded without a knowlwedge of the DTDs.  
# Later I will edit the body of the routine directly (using info body)
#========================================================================

# this is run after every ESIS file has been read in.  It can be used to
# transform data, though you should be careful since the user won't know.

proc CW::userProcessESIS {} {
}

# this processes hypertext further (e.g. inlining)
# the hypertext must be normalised to have <A>...</A> all on one line
proc userProcessHypertext {contents} {

    set contents [XML::processHypertext $contents]
    set contents [MOL::processHypertext $contents]
}

#========================================================================
# These local routines cross more than one DTD and are messy.  (e.g.
# sending signals.  I'll try to work out where they best go.
#========================================================================

source $CW(CWDIR)/misc_local.tcl

