#=========================================================================
# MANAGEMENT OF LOCAL RESOURCES (E.G. ENVIRONMENT VARIABLES, HELPERS)
#          NOT DTD-dependent (see customisation.tcl for that)
#                        YOU MAY EDIT THIS FILE
#=========================================================================

puts "Reading costwishini.tcl ..."

# routines that may need to be customised locally
# look at this carefully, and edit appropriate bits.

    global env CW

# essential directory structure - should have been set with setup.csh
    if {![info exists env(COSTWISH)]} {
        puts stderr "ERROR: No environment variable COSTWISH (see setup.csh)"
        exit
    }
    set CW(COSTWISH) $env(COSTWISH)
    if {![info exists env(CWDIR)]} {
        GUI::errorMessage "No environment variable CWDIR; abort"
        exit
    }
    set CW(CWDIR) $env(CWDIR)
    
# library for html_library.tcl, etc. (This should be standard)
    set CW(LIBDIR) $env(CWDIR)/library



#========================================================================
# customise SGML parsing, environment, etc
#========================================================================
proc SGML::userInitialise {} {
    global env CW

    puts "Initialising SGML environment..."

# set up catalogs
    set catalogList ""
    if {[info exists env(CW_CATALOGS)]} {
        if {![file exists $env(CW_CATALOGS)]} {
            GUI::errorMessage "No file found for CW_CATALOGS: ($env(CW_CATALOGS))"
        } else {
            set CW(CATALOG,LIST) [SGML::readCatalogs $env(CW_CATALOGS)]
            if {$CW(CATALOG,LIST) == ""} {
                GUI::errorMessage "Could not read any catalogs from \"$env(CW_CATALOGS)\"\n.  Check that this file exists and that it has some catalog pointers
in it."
            }
        }
    }

    set catalogs ""
# are there multiple catalogs listed in a file? If so, append them
    if {[info exists CW(CATALOG,LIST)]} {
        foreach catalog $CW(CATALOG,LIST) {
            append catalogs " -m $catalog"
        }
    }
    if {$catalogs == ""} {
        if {[info exists env(COSTWISHDTD)] && [file exists $env(COSTWISHDTD)]} {
            set catalogs "-m $env(COSTWISHDTD)/catalog"
        }
        
    }
    if {$catalogs == ""} {
        puts stderr "ERROR: No catalogs located - set environment variables COSTWISHDTD or CW_CATALOGS (see setup.csh)"
        exit
    }
    set sgmldecl ""
    if {[info exists env(SGML_DECLARATION)]} {
        set sgmldecl "$env(SGML_DECLARATION)"
    } else {
        GUI::errorMessage "WARNING: SGML_DECLARATION not set\nYou may well get parsing errors unless your documents parse against the default SGML declaration"
    }

# POSSIBLE EDIT -----------------------------------------------------------
# YOU MAY NEED TO EDIT THIS WITH THE FULL FILE NAME IF PATH IS NOT SET
    set sgmls "sgmls"
# (CHECK!!)check that this works before trying to read SGML files in costwish!
    SGML::setCommand SGML "$sgmls $catalogs $sgmldecl"
# -------------------------------------------------------------------------



# POSSIBLE EDIT -----------------------------------------------------------
# binaries - only used at present for running dtdless option
    set CW(BINDIR) $env(COSTWISH)/bin

# this will translate normalised SGML files without a DTD
    SGML::setCommand NORM "$CW(BINDIR)/dtdless"
# -------------------------------------------------------------------------
}

#========================================================================
# helpers (not DTD-dependent)
#========================================================================

# POSSIBLE EDIT -----------------------------------------------------------
# to display gifs
    set CW(GIF,DISPLAYCOMMAND) xv
# -------------------------------------------------------------------------

