#
# MultiColumn - multiple columns with scrollbar
#

# MultiColumnList
#
# Public attributes:
#   -size		initial size of lists
#   -select_command	command when row is selected
#
# Methods:
#   clearAllColumns {}
#   addRow {item_list}
#   getRow {row_no}
#

itcl_class MultiColumnList {
  constructor {columns column_names config} {
    set no_of_columns $columns

    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::frame $this -class $class -relief flat
    ::rename $this $this-win-
    ::rename $this-tmp- $this

    frame $this.scrollframe
    label $this.scrollframe.label
    scrollbar $this.scrollframe.scroll -command "$this scrollLists"\
	-relief sunken -width 12p
    pack $this.scrollframe.label -side top
    pack $this.scrollframe.scroll -side top -expand yes -fill y
    pack $this.scrollframe -side right -fill y

    for {set i 0} {$i < $no_of_columns} {incr i} {
      if {$i < [llength $column_names]} \
      { set name [lindex $column_names $i] } \
      else { set name "" }

      frame $this.frame$i
      label $this.frame$i.label -text $name

      listbox $this.frame$i.list -yscroll "$this.scrollframe.scroll set" \
	-relief sunken -width $columnwidth -height $columnheight \
	-setgrid yes -exportselection no -selectmode $selectmode
#      tk_listboxSingleSelect $this.frame$i.list
      pack $this.frame$i.label -side top -fill both -expand no
      pack $this.frame$i.list -side top -fill both -expand yes
      if {$i == [expr $no_of_columns - 1]} {
        pack $this.frame$i -side left -fill both -expand yes
      } else {
        pack $this.frame$i -side left -fill y -expand no
      }
      bind $this.frame$i.list <ButtonRelease-1> "$this _listClick %x %y"
      bind $this.frame$i.list <Double-ButtonRelease-1> "$this _listClickDouble %x %y"
    }
  }

  destructor {
    ::rename $this-win- {}
    destroy $this
  }

  method config {config} {}

  method scrollLists args {
    for {set i 0} {$i < $no_of_columns} {incr i} {
      eval "$this.frame$i.list yview $args"
    }
  }

  method _listClick {x y} \
  { set index [$this.frame0.list nearest $y]
    for {set i 0} {$i < $no_of_columns} {incr i} \
    { if {$selectmode == "single"} \
      { $this.frame$i.list selection clear 0 end }
      $this.frame$i.list selection set $index $index
    }

    if {$select_command != ""} {
      eval "$select_command $index"
    }
  }

  method _listClickDouble {x y} \
  { set index [$this.frame0.list nearest $y]

    if {$select_command != ""} \
    { eval "$doubleclick $index" }
  }

  method clearAllColumns {} \
  { for {set i 0} {$i < $no_of_columns} {incr i} \
    { $this.frame$i.list delete 0 end }
  }

  method clearSelection {} \
  { for {set i 0} {$i < $no_of_columns} {incr i} \
    { $this.frame$i.list selection clear 0 end }
  }

  method selectRow {row {call_callback 1}} \
  { for {set i 0} {$i < $no_of_columns} {incr i} \
    { $this.frame$i.list selection clear 0 end
      $this.frame$i.list selection set $row $row
    }
    if {$call_callback == 1 && $select_command != ""} \
    { eval "$select_command $row" }
  }

  method addRow {items} \
  { set i 0
    foreach item $items \
    { if {$i < $no_of_columns} \
      { $this.frame$i.list insert end $item }
      incr i
    }
  }

  method replaceRow {row items} \
  { for {set i 0} {$i < $no_of_columns} {incr i} \
    { $this.frame$i.list delete $row
      $this.frame$i.list insert $row [lindex $items $i]
    }
  }

  method deleteRow {row} \
  { for {set i 0} {$i < $no_of_columns} {incr i} \
    { $this.frame$i.list delete $row }
  }

  method getRow {row_index} \
  { set result {}
    for {set i 0} {$i < $no_of_columns} {incr i} \
    { lappend result [$this.frame$i.list get $row_index] }

    return $result
  }

  method setWidth {column width} {
    set height [lindex [$this.frame0.list configure -height] 3]
#    set height [lindex [split [$this.frame0.list configure -configure] x] 1]
    $this.frame${column}.list configure -height $height
    $this.frame${column}.list configure -width $width
#    $this.frame${column}.list configure -geometry "${width}x${height}"
  }

  public select_command ""
  public selectmode "single"
  public doubleclick ""
  public size "1x1"
  public columnwidth 1
  public columnheight 1

  protected no_of_columns 1
  protected column_width
}





