# envVal envValName
#   Looks up the envValName environment variable and returns its
#   value, or {} if it does not exists
proc envVal {envValName} {
  global env
  if [info exists env($envValName)] {return $env($envValName)} {return {}}
}

# loadAppDefaults classNameList ?priority?
#   Searches for the app-default files corresponding to classNames in
#   the order specified by X Toolkit Intrinsics, and loads them with
#   the priority specified (default: startupFile).
proc loadAppDefaults {classNameList {priority startupFile}} {
  set filepath "[split [envVal XUSERFILESEARCHPATH] :] \
		[envVal XAPPLRESDIR] \
		[split [envVal XFILESEARCHPATH] :] \
		/usr/lib/X11"
  foreach i $classNameList {
    foreach j $filepath {
      if {[file exists $j/$i]} {
	option readfile $j/$i $priority; break
      }
    }
  }
}
