### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
# This is the save function, which writes the internal
# state to a file
############################################################
proc saveFile {} {
  global module progList changed saveInfo children widgetArgs ok \
      fillList fillOutCounter scrollValue setup editInfo state
  
  set saved {}
  set hash "\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#"

  if {![file exists ~/.dotfile]} {
    exec mkdir [glob ~/].dotfile
  }
  ### creating the "please wait" window
  set waitWin [makeTempWindow "Saving"]
  label $waitWin.label -text "Please Wait\nSaving to file ~/.dotfile/$module(name)" -font -*-helvetica-medium-r-*-*-18-*
  pack $waitWin.label
  update

  set FILE [open ~/.dotfile/$module(name) w]

  puts $FILE "$hash\n\# Dotfile Generator version $editInfo(version)\n\# $module(name) module version $module(version)\n$hash\n"

  foreach function $progList {
    puts $FILE "$hash\n\# $function\n$hash"
    foreach child $children(${function}__top) {
      saveOptions $FILE $function $function $child
    }
  }
  
  puts $FILE "$hash\n\# setup\n$hash"
  foreach elm [array names setup] {
    puts $FILE "set setup($elm) \{$setup($elm)\}"
  }

  puts $FILE "$hash\n\# saveInfo\n$hash"
  foreach elm [array names saveInfo] {
    puts $FILE "set saveInfo($elm) $saveInfo($elm)"
  }

  puts $FILE "$hash\n\# state\n$hash"
  foreach elm [array names state] {
    if {$state($elm) == "disabled"} {
      puts $FILE "set state($elm) $state($elm)"
    }
  }

  if {[info exists fillList]} {
    puts $FILE "$hash\n\# fillList (fillouts)\n$hash"
    foreach elm [array names fillList] {
      puts $FILE "set fillList($elm) \{$fillList($elm)\}"
    }
    puts $FILE "set fillOutCounter $fillOutCounter"
  }

  close $FILE
  set changed 0
  catch "destroy $waitWin"
}

############################################################
# This function escapes every control chars for the
# save file
############################################################  
proc escape {string} {
  regsub -all {["#\${}]} $string \\\\\\0 result
  regsub -all {[[]} $result \\\\\\0 string
  regsub -all {[]]} $string \\\\\\0 result
  return $result
}

############################################################
# This function write every user configuration options
# to the save file.
############################################################
proc saveOptions {FILE function prefix name} {
  global widgetArgs children scrollValue fillList
  set type $widgetArgs(${function}__${name}__type)
  switch $type {
    checkbox -
    entry -
    int -
    float -
    textbox -
    listbox -
    menu -
    radio -
    label  {
      puts $FILE "setVar $function $name ${prefix}_$name {[escape [uplevel \#0 set ${prefix}_$name]]}"
    }
    extentry {
      puts $FILE "setVar $function $name scrollValue(${prefix}_${name}) {$scrollValue(${prefix}_${name})}"
      set count [lindex $scrollValue(${prefix}_${name}) 0]
      for {set i 0} {$i < $count } {incr i} {
	foreach child $children(${function}__$name) {
	  saveOptions $FILE $function ${prefix}_$name$i $child
	}
      }
    }
    frame {
      foreach child $children(${function}__$name) {
	saveOptions $FILE $function ${prefix}_$name $child
      }
    }
    fillout {
      puts $FILE "setVar $function $name ${prefix}_$name {[escape [uplevel \#0 set ${prefix}_$name]]}"
      if {[info exists fillList(${prefix}_$name)]} {
	foreach elm $fillList(${prefix}_$name) {
	  set elmName [lindex $elm 2]
	  set counter [lindex $elm 3]
	  if {$counter == -1} continue
	  foreach child $children(${function}__$elmName) {
	    saveOptions $FILE $function ${prefix}_${name}_$counter $child
	  }
	}
      }
    }
    header -
    line {}
    default {
      error "Unknow type: $type"
    }
  }
}

############################################################
# This function read in the save file, and initialise
# those variable which haven't been set in from the save file
############################################################
proc initialize_and_load {} {
  global loadedWidgets progList argv module children editInfo widgetArgs \
      changedFunctions changeElm initFunc

  ### initializing the list of widget which have been loaded.
  foreach function $progList {
    set loadedWidgets($function) {}
  }

  ### asking wether to import file or not
  set import 0
  if {![file exists ~/.dotfile/$module(name)] \
	  && [file exists [lindex $argv 1]/generalDotfile]} {
    set answer [tk_dialog .dialog "Load data" "Would you like to install a general dotfile for the $module(name) module. (You don't have one yourself)" questhead 0 Yes No]
    if {$answer == 0} {
      if {![file exists ~/.dotfile]} {
	exec mkdir [glob ~/].dotfile
      }
      exec cp [lindex $argv 1]/generalDotfile [glob ~]/.dotfile/$module(name)
      set import 1
    } else {
      set import -1
    }
  }
  if {[file exists ~/.dotfile/$module(name)] && $import == 0} {
    set answer [tk_dialog .dialog "Load data" "A save file exists. Load it?" questhead 0 Yes No]
    if {$answer == 0} {
      set import 1
    }
  }

  ### importing the file
  if {$import == 1} {
    updateSaveFile
    uplevel \#0 "source ~/.dotfile/$module(name)"
  }

  set changedFunctions ""
  ### initializing the widgets which haven't been loaded
  set w [makeTempWindow Loading]
  label $w.label -font  -*-helvetica-medium-r-*-*-18-* \
      -text "Loading, please wait .... "
  pack $w.label
  if {$import != 1} {
    pack [label $w.label2 -text "To avoid this extra time, please make\n a save file, by pressing \"Save\"" -justify left]
  }
  update
  
  foreach function $progList {
    set editInfo(name) $function
    foreach child $children(${function}__top) {
      set default $widgetArgs(${function}__${child}__default)
      initializeNonSet $function $function $child $default
    }
  }
  catch "destroy $w"
  
  ### calling the initfunction for all those pages which have been changed
  foreach function $changedFunctions {
    set editInfo(name) $function
    linkVars $function top
    if {[info exists initFunc($function)]} {
      set changeElm init
      uplevel \#0 $initFunc($function)
    } else {
      # the init func, doesn't exist call change with all element activated.
      foreach child $children(${function}__top) {
	changeAll $child
      }
    }
    unlink top ""
  }
  
  set editInfo(name) ""
  unset loadedWidgets
  unset changedFunctions
}

############################################################
#   This function is used in the savefile, to register
#   which variables are set.
############################################################
proc setVar {function child variable value} {
  global loadedWidgets scrollValue
  uplevel \#0 "set $variable \"$value\""
  lappend loadedWidgets($function) $child
}

############################################################
# This function set those variable which haven't been
# set in the save file
############################################################
proc initializeNonSet {function prefix name default} {
  global children widgetArgs loadedWidgets scrollValue changedFunctions

  set type $widgetArgs(${function}__${name}__type)
  switch $type {
    checkbox -
    entry -
    int -
    float -
    menu -
    listbox -
    textbox -
    radio -
    label -
    fillout {
      if {[lsearch -exact $loadedWidgets($function) $name] == -1} {
	setVariable $name $prefix $default
	uniqAppend changedFunctions $function
      }
    }
    extentry {
      if {[lsearch -exact $loadedWidgets($function) $name] == -1} {
	### the extentry doesn't exists at all
	setVariable $name $prefix $default
		lappend changedFunctions $function
      } else {
	### there might have come a new element in the extentry
	set count [lindex $scrollValue(${prefix}_${name}) 0]
	set index 0
	foreach child $children(${function}__$name) {
	  set subtype $widgetArgs(${function}__${child}__type)
	  if {$subtype == "line" || $subtype == "header"} continue
	  if {[lsearch -exact $loadedWidgets($function) $child] == -1} {
	    for {set i 0} {$i < $count} {incr i} {
	      set subDefault [lindex [lindex $default $i] $index]
	      initializeNonSet $function ${prefix}_$name$i $child $subDefault
	    }
	  }
	  incr index
	}
      }
    }
    line -
    header {}
    frame {
      set index 0
      foreach child $children(${function}__$name) {
	set subtype $widgetArgs(${function}__${child}__type)
	if {$subtype == "line" || $subtype == "header"} continue
	set subDefault [lindex $default $index]
	initializeNonSet $function ${prefix}_$name $child $subDefault
	incr index
      }
    }
    default {
      error "Unknown type: $type"
    }
  }
}

