proc page_config {w} {

  catch "destroy .page_config"
  toplevel .page_config 
  wm title .page_config {page_config}

  set Name .page_config
  set Parent $Name

  set Name $Parent.f16
  #------------------------------------------
  frame $Name -height 48 -relief raised -width 136
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f16.b17
  #------------------------------------------
  button $Name -text {Add Page } -command "add_page $w"
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
  
  set Name $Parent.f16.b18
  #------------------------------------------
  button $Name -text {Done} -command "destroy .page_config"
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
  
  foreach p [$w pages] {
    echo $p
    add_page_config .page_config $w $p
  }
}

set page_num 0
proc add_page {w} {
  global page_num
  set again 1
  while {[set again]} {
    incr page_num
    set again 0
    foreach page [$w pages] {
      if {"page$page_num" == $page} {set again 1}
    }
  }
  $w add page$page_num -label "New Page"
  add_page_config .page_config $w page$page_num
}
  
set apc 0

proc add_page_config {Parent w page} {
  global apc
  set Name $Parent.f19$apc
  #------------------------------------------
  frame $Name -borderwidth 1 -height 50 -relief raised -width 50
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  set Name $Parent.f19$apc.l20
  #------------------------------------------
  label $Name -relief raised -text {Page Name:}
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 3 -pady 0 -side left
  
  set Name $Parent.f19$apc.e21
  #------------------------------------------
  entry $Name 
  pack $Name -anchor center -expand 1 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
  bind $Name <KeyPress> "after 100 $w pageconfig $page -label {\[$Name get\]}"
  
  $Name insert end [lindex [$w pageconfig $page -label] 4]

  set Name $Parent.f19$apc.b22
  #------------------------------------------
  button $Name -text {Delete Page} -command "$w delete $page \n destroy $Parent.f19$apc"
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
  incr apc
}
