#!/usr/local/bin/tclsh
set rcsId {$Id: xifo.tcl,v 1.6 1995/12/03 20:16:02 jfontain Exp $}

source stooop.tcl

proc xifo::xifo {this size} {
    set xifo($this,size) $size
    xifo::empty $this
}

proc xifo::~xifo {this} {
    global xifo${this}data

    catch {unset xifo${this}data}
}

proc xifo::in {this data} {
    global xifo${this}data

    xifo::tidyUp $this
    if {[array size xifo${this}data]>=$xifo($this,size)} {
        unset xifo${this}data($xifo($this,first))
        incr xifo($this,first)
    }
    set xifo${this}data([incr xifo($this,last)]) $data
}

proc xifo::tidyUp {this} {
    # warning: for internal use only
    global xifo${this}data

    catch {
        unset xifo${this}data($xifo($this,unset))
        unset xifo($this,unset)
    }
}

proc xifo::empty {this} {
    global xifo${this}data

    catch {unset xifo${this}data}
    catch {unset xifo($this,unset)}
    set xifo($this,first) 0
    set xifo($this,last) -1
}

proc xifo::isEmpty {this} {
    global xifo${this}data

    return [expr [array size xifo${this}data]==0]
}

virtual proc xifo::out {this}

virtual proc xifo::data {this}


proc lifo::lifo {this {size 2147483647}} xifo {$size} {}

proc lifo::~lifo {this} {}

proc lifo::out {this} {
    global xifo${this}data

    xifo::tidyUp $this
    if {[array size xifo${this}data]==0} {
        error "lifo $this out error, empty"
    }
    # delay unsetting popped data to improve performance by avoiding a data copy
    set xifo($this,unset) $xifo($this,last)
    incr xifo($this,last) -1
    return [set xifo${this}data($xifo($this,unset))]
}

proc lifo::data {this} {
    global xifo${this}data

    set list {}
    set first $xifo($this,first)
    for {set index $xifo($this,last)} {$index>=$first} {incr index -1} {
        lappend list [set xifo${this}data($index)]
    }
    return $list
}


proc fifo::fifo {this {size 2147483647}} xifo {$size} {}

proc fifo::~fifo {this} {}

proc fifo::out {this} {
    global xifo${this}data

    xifo::tidyUp $this
    if {[array size xifo${this}data]==0} {
        error "fifo $this out error, empty"
    }
    # delay unsetting popped data to improve performance by avoiding a data copy
    set xifo($this,unset) $xifo($this,first)
    incr xifo($this,first)
    return [set xifo${this}data($xifo($this,unset))]
}

proc fifo::data {this} {
    global xifo${this}data

    set list {}
    set last $xifo($this,last)
    for {set index $xifo($this,first)} {$index<=$last} {incr index} {
        lappend list [set xifo${this}data($index)]
    }
    return $list
}

if 1 {
    proc exercise {id} {
        for {set u 0} {$u<10} {incr u} {
            xifo::in $id $u
        }
        puts [xifo::out $id]
        puts [xifo::data $id]
        xifo::in $id $u
        xifo::in $id [incr u]
        puts [xifo::data $id]
    }

    set id [new lifo 10]
    exercise $id
    delete $id

    set id [new fifo 10]
    exercise $id
    delete $id
}
