source stooop.tcl

# expected output:
## a::a 1
## b::b 1
## b::f 1 x y {1 2} 3
## a::g 1 x y {1 2} 3

proc a::a {this} {
    puts "a::a $this"
}
proc a::~a {this} {
    puts "a::~a $this"
}
virtual proc a::f {this p args} {}
proc a::g {this p args} {
    puts "a::g $this $p $args"
}
proc b::b {this} a {} {
    puts "b::b $this"
}
proc b::~b {this} {
    puts "b::~b $this"
}
virtual proc b::f {this p args} {
    puts "b::f $this $p $args"
}

set o [new b]
a::f $o {x y} {1 2} 3
a::g $o {x y} {1 2} 3
