source parray.tcl
source stooop.tcl

# expected output:
## a::a 1 x y {1 2} 3
## b::b 1 x y {1 2} 3
## a(1,_derived) = b
## a(1,m) = 1 2
## b(1,n) = 1 2

proc a::a {this p args} {
    puts "a::a $this $p $args"
    set a($this,m) [lindex $args 0]
}
proc a::~a {this} {
    puts "a::~a $this"
}
proc b::b {this p args} a {$p $args} {
    puts "b::b $this $p $args"
    set b($this,n) [lindex $args 0]
}
proc b::~b {this} {
    puts "b::~b $this"
}

new b {x y} {1 2} 3
printArrays a b
