# This is a sample script to test orbsh with the Orbix grid demo
# It has only been tested on OrbixMT 1.3.4 on Solaris 2.4
#
# For this demo to run properly you must modify the standard grid Makefile
# 
# 1. Add the -R flag to the IDLFLAGS line in the Makefile. It should look like:
#       IDLFLAGS = -B -R
# 2. rmit grid (this may be overkill)
# 3. make clean
# 4. make
# 5. Follow make instructions for executing putit
# 6. set the hostname variable below to the grid server host
# 6. Run this script with "orbsh grid.tcl"
#
#

# This is for itcl namespaces.  The catch allows it to still function
# under standard tcl
catch {import add tclIR}

# This should probably just be set using [info hostname]
set host "washington.jhuapl.edu"

# This is Orbix 1.3 specific and will almost definitely fail on other 
# ORBs.  I do not recommend using the stringified object references in
# Tcl scripts because it is very error prone and non portable.  Look at
# the documentation for ways to avoid this.
set objRef ":\\$host:grid:::IR:grid.idl\$grid"

puts "height is [getAttribute $objRef height]"
puts "width  is [getAttribute $objRef width]"

invokeMethod $objRef set n 2 m 4 value 123

puts "grid\[2,4\] is [invokeMethod $objRef get n 2 m 4]"

# We will now do a quick exception handling check

puts ""
puts "We will now try to get the ORB to raise an exception by invoking a"
puts "write on a read-only attribute"
puts ""

if {[catch {setAttribute $objRef height 200} msg] == 1} {
    puts "caught the exception"
    puts $msg
} else {
    puts "failed to catch the exception...uh oh..."
}
