#
# Name
#
#   tkGrep_global.tcl
#
# Version
#
#   1.0
#
# Description
#
#   Contains global definitions used in tkGrep
#
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
# Modification History
#
# Name              Date         Comment
# ~~~~~~~~~~~~~~~   ~~~~~~~~~~   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Wes Bailey        1996.05.06   Created.
#

set tkGrep(HOME) $env(HOME)

set tkGrep(WORKDIR) ""
set tkGrep(FILENAME) ""
set tkGrep(PATTERN) ""
set tkGrep(OPTION) ""
set tkGrep(SEPERATOR) ""
set tkGrep(COLUMN) ""

# Define global image variables.
set tkGrep(IMAGEDIR) "/home/wesb/tkWorld_src/image"
set tkGrep(IMAGE_TKGREP) [image create photo \
	-file $tkGrep(IMAGEDIR)/tkWorld_tkgrep.gif]
set tkGrep(IMAGE_RUN) [image create photo \
	-file $tkGrep(IMAGEDIR)/tkWorld_run.gif]
set tkGrep(IMAGE_EXIT) [image create photo \
	-file $tkGrep(IMAGEDIR)/tkWorld_exit.gif]
set tkGrep(IMAGE_RESET) [image create photo \
	-file $tkGrep(IMAGEDIR)/tkWorld_reset.gif]
set tkGrep(IMAGE_CLEAR) [image create photo \
	-file $tkGrep(IMAGEDIR)/tkWorld_clear.gif]
set tkGrep(IMAGE_HELP) [image create photo \
	-file $tkGrep(IMAGEDIR)/tkWorld_help.gif]
set tkGrep(IMAGE_SAVE) [image create photo \
	-file $tkGrep(IMAGEDIR)/tkWorld_save.gif]

# Define help messages which appear when mouse enters the defined
#    widget.
set tkGrep(HELP.top) "Command settings"
set tkGrep(HELP.bottom) "LOG Window"
set tkGrep(HELP.middle.run) "Execute grep command"
set tkGrep(HELP.middle.reset) "Reset command settings"
set tkGrep(HELP.middle.clear) "Clear the LOG window"
set tkGrep(HELP.middle.save) "Save LOG window to file" 
set tkGrep(HELP.middle.help) "View help documentation"
set tkGrep(HELP.middle.exit) "Exit tkGrep"

# Define the error messages.

set tkGrep(ERROR,SE) "Syntax Error"
set tkGrep(ERROR,IWD) "Invalid Working Directory"
set tkGrep(ERROR,FDNE) "Filename Does Not Exist"
set tkGrep(ERROR,FNF) "Filename Not File"
set tkGrep(ERROR,RPD) "Read Permission Denied"
set tkGrep(ERROR,ISP) "Invalid Search Pattern"
set tkGrep(ERROR,SNSC) "Seperator Not Single Character"
set tkGrep(ERROR,SNS) "Seperator Not Specified"
set tkGrep(ERROR,CNS) "Columns Not Specified"
set tkGrep(ERROR,ID) "Invalid Delimeter"