# Program: xf
# Description: procedures that implement the help functionality
#
# $Header: xfprocHelp.tcl[2.4] Wed Mar 10 12:07:53 1993 garfield@garfield frozen $

proc XFProcHelpAbout {} {
##########
# Procedure: XFProcHelpAbout
# Description: show the about box
# Arguments: none
# Returns: none
# Sideeffects: none
##########
  global xfAlertBox
  global xfPath

  if {[file exists $xfPath(base)/lib/About.H]} {
    set xfAlertBox(toplevelName) .about
    XFProcMessageFile $xfPath(base)/lib/About.H 290x240 {XF about} center {}
    set xfAlertBox(toplevelName) .xfAlertBox
  }
}

proc XFProcHelpHelp {args} {
##########
# Procedure: XFProcHelpHelp
# Description: show help in a external wish
# Arguments: args - the section (page) to show
# Returns: none
# Sideeffects: none
##########
  global env
  global xfPath

  if {[catch "exec netscape $xfPath(base)/Help/index.html &" xfResult]} {
    if {[catch "exec mosaic $xfPath(base)/Help/index.html &" xfResult]} {
      XFProcError $xfResult
    }
  }
}

proc XFProcHelpTutorial {} {
##########
# Procedure: XFProcHelpTutorial
# Description: start tutorial
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  global xfConf
  global xfPath

  if {[XFProcYesNo "Running the tutorial will erase your current work.\n Is this ok ?"]} {
    if {$xfConf(kanji)} {
      catch "exec true; exec $xfConf(interpreterTut) -name \"XF-tutorial\" -file $xfPath(base)/xftutorial/xftutorial.tcl $xfPath(base)/xftutorial/script.xfjp [winfo name .] &"
    } {
      catch "exec true; exec $xfConf(interpreterTut) -name \"XF-tutorial\" -file $xfPath(base)/xftutorial/xftutorial.tcl $xfPath(base)/xftutorial/script.xf [winfo name .] &"
    }
  }
}

# eof

